package ru.yandex.direct.communication.inventory;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.communication.model.inventory.ClientsResponse;
import ru.yandex.direct.communication.model.inventory.Request;
import ru.yandex.direct.communication.model.inventory.Response;
import ru.yandex.direct.http.smart.annotations.ProtoAsJson;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.http.Body;
import ru.yandex.direct.http.smart.http.GET;
import ru.yandex.direct.http.smart.http.Headers;
import ru.yandex.direct.http.smart.http.POST;
import ru.yandex.direct.http.smart.http.Query;

@ParametersAreNonnullByDefault
public interface CommunicationInventoryApi {

    @POST("/get_events")
    @ProtoAsJson
    @Headers({"Content-Type: application/json"})
    Call<Response> getEvents(@ProtoAsJson @Body Request request);

    @GET("/get_client_ids_by_slot_id")
    @ProtoAsJson
    @Headers({"Content-Type: application/json"})
    Call<ClientsResponse> getClientsBySlot(@Query("slot_id") long slotId);
}
