package ru.yandex.direct.communication.inventory;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.asynchttp.ParallelFetcherFactory;
import ru.yandex.direct.communication.model.inventory.ClientsResponse;
import ru.yandex.direct.communication.model.inventory.Request;
import ru.yandex.direct.communication.model.inventory.Response;
import ru.yandex.direct.http.smart.core.Smart;

public class CommunicationInventoryClient {
    private static final Logger logger = LoggerFactory.getLogger(CommunicationInventoryClient.class);

    private final CommunicationInventoryApi inventoryApi;

    public CommunicationInventoryClient(String baseUrl, ParallelFetcherFactory fetcherFactory) {
        inventoryApi = Smart.builder()
                .withParallelFetcherFactory(fetcherFactory)
                .withProfileName("inventory_object_events")
                .withBaseUrl(baseUrl)
                .build()
                .create(CommunicationInventoryApi.class);
    }

    public Response getRecommendations(Request request) {
        logger.info("Communication request body: " + request);
        var call = inventoryApi.getEvents(request);
        var response =  call.execute();
        logger.info("Communication request: " + call.getRequest().getAHCRequest());
        var result = response.getSuccess();
        if (result == null) {
            throw new RuntimeException(response.getErrors().iterator().next());
        }
        logger.info("Communication response: " + result);
        return result;
    }

    public ClientsResponse getClientsBySlot(long slotId) {
        var call = inventoryApi.getClientsBySlot(slotId);
        var response = call.execute();
        var result = response.getSuccess();
        if (result == null) {
            throw new RuntimeException(response.getErrors().iterator().next());
        }
        logger.info("Communication response: " + result);
        return result;
    }
}
