package ru.yandex.direct.communication.repository;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.communication.model.Slot;

@Repository
public class CommunicationSlotRepository {

    private final Map<String, Slot> slotByName = new HashMap<>();
    private final Map<Long, Slot> slotById = new HashMap<>();

    @Autowired
    public CommunicationSlotRepository() {
        StreamEx.of(
                Slot.newBuilder()
                        .setId(1)
                        .setName("popup")
                        .addTargetObjectTypes(Slot.ESlotTargetObjectType.USER)
                        .addTargetObjectTypes(Slot.ESlotTargetObjectType.CLIENT)
                        .addTargetObjectTypes(Slot.ESlotTargetObjectType.CAMPAIGN)
                        .build(),
                Slot.newBuilder()
                        .setId(2)
                        .setName("onboarding")
                        .addTargetObjectTypes(Slot.ESlotTargetObjectType.CLIENT)
                        .setShowAll(true)
                        .build(),
                Slot.newBuilder()
                        .setId(3)
                        .setName("wallet_balance")
                        .addTargetObjectTypes(Slot.ESlotTargetObjectType.CLIENT)
                        .build(),
                Slot.newBuilder()
                        .setId(4)
                        .setName("master_edit_camp")
                        .addTargetObjectTypes(Slot.ESlotTargetObjectType.CAMPAIGN)
                        .build(),
                Slot.newBuilder()
                        .setId(5)
                        .setName("master_show_camp")
                        .addTargetObjectTypes(Slot.ESlotTargetObjectType.CAMPAIGN)
                        .build(),
                Slot.newBuilder()
                        .setId(6)
                        .setName("camp_grid")
                        .addTargetObjectTypes(Slot.ESlotTargetObjectType.CAMPAIGN)
                        .build(),
                Slot.newBuilder()
                        .setId(7)
                        .setName("recommendation_dashboard_old")
                        .addTargetObjectTypes(Slot.ESlotTargetObjectType.CAMPAIGN)
                        .build(),
                Slot.newBuilder()
                        .setId(8)
                        .setName("show_camp")
                        .addTargetObjectTypes(Slot.ESlotTargetObjectType.CAMPAIGN)
                        .build(),
                Slot.newBuilder()
                        .setId(9)
                        .setName("MAIL")
                        .addTargetObjectTypes(Slot.ESlotTargetObjectType.USER)
                        .build(),
                Slot.newBuilder()
                        .setId(10)
                        .setName("auto_apply_price")
                        .addTargetObjectTypes(Slot.ESlotTargetObjectType.CAMPAIGN)
                        .build(),
                Slot.newBuilder()
                        .setId(11)
                        .setName("group_grid")
                        .addTargetObjectTypes(Slot.ESlotTargetObjectType.GROUP)
                        .build(),
                Slot.newBuilder()
                        .setId(12)
                        .setName("banner_grid")
                        .addTargetObjectTypes(Slot.ESlotTargetObjectType.BANNER)
                        .build(),
                Slot.newBuilder()
                        .setId(13)
                        .setName("recommendation_dashboard")
                        .addTargetObjectTypes(Slot.ESlotTargetObjectType.CAMPAIGN)
                        .build(),
                Slot.newBuilder()
                        .setId(14)
                        .setName("camp_grid_budget_column")
                        .addTargetObjectTypes(Slot.ESlotTargetObjectType.CAMPAIGN)
                        .build()
        ).forEach(slot -> {
            slotByName.put(slot.getName(), slot);
            slotById.put(slot.getId(), slot);
        });
    }

    public List<Slot> getSlotsByNames(Collection<String> names) {
        return StreamEx.of(names)
                .map(slotByName::get)
                .nonNull()
                .toList();
    }

    public List<Slot> getSlotsByIds(Collection<Long> ids) {
        return StreamEx.of(ids)
                .map(slotById::get)
                .nonNull()
                .toList();
    }
}
