package ru.yandex.direct.communication.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.campaign.service.validation.type.disabled.DisabledField;
import ru.yandex.direct.core.entity.campaign.service.validation.type.disabled.DisabledFieldsDataProvider;
import ru.yandex.direct.dbutil.model.ClientId;

@Service
public class DisabledFieldsDataProviderImpl implements DisabledFieldsDataProvider {

    private final CommunicationChannelService channelService;

    @Lazy
    @Autowired
    public DisabledFieldsDataProviderImpl(CommunicationChannelService channelService) {
        this.channelService = channelService;
    }

    @Override
    public Map<Long, Map<DisabledField, Object>> getCampaignDisabledData(
            ClientId clientId,
            Long operatorUid,
            Collection<Long> cids
    ) {
        return channelService.getCampaignDisabledData(
                clientId,
                Set.of(CommunicationEventService.AUTO_APPLY_PRICE_SLOT),
                new ArrayList<>(cids)
        );
    }
}
