package ru.yandex.direct.crm.client

import ru.yandex.direct.asynchttp.ParallelFetcherFactory
import ru.yandex.direct.http.smart.core.Smart
import ru.yandex.direct.http.smart.error.ErrorUtils.checkResultForErrors
import ru.yandex.direct.tvm.TvmIntegration
import ru.yandex.direct.tvm.TvmService
import java.util.UUID

open class CrmClient(
    configuration: CrmConfiguration,
    parallelFetcherFactory: ParallelFetcherFactory,
    tvmIntegration: TvmIntegration
) {

    data class CrmConfiguration(val tvmService: TvmService, val crmApiUrl: String)

    private val crmApi = Smart.builder()
        .withParallelFetcherFactory(parallelFetcherFactory)
        .useTvm(tvmIntegration, configuration.tvmService)
        .withProfileName("crm-api")
        .withBaseUrl(configuration.crmApiUrl)
        .addHeaderConfigurator { it.add("Content-type", "plain/text") }
        .build()
        .create(CrmClientApi::class.java)

    /**
     * Отправка формы обратной связи (ФОС) в формате письма
     */
    fun sendFosMail(
        login: String,
        email: String,
        source: String,
        body: String,
        attachmentUrl: String?
    ) {
        val deliveryId = UUID.randomUUID()
        val request = crmApi.sendFosMail(
            xDeliveryId = deliveryId.toString(),
            xMailTo = "CRM <client-service@yandex-team.ru>",
            xMailFrom = "$login <$email>",
            xMailSubject = source,
            xMailFiles = attachmentUrl,
            body = body,
        )
        val res = request.execute()
        checkResultForErrors(res, { RuntimeException(it) })
    }
}
