package ru.yandex.direct.crypta.client

import java.util.Locale

import ru.yandex.crypta.siberia.bin.custom_audience.suggester.grpc.TItem
import ru.yandex.direct.crypta.client.model.CryptaSuggestCampaignType

/**
 * Клиент для работы с Crypta
 */
interface CryptaClient {

    /**
     * Получить список рекомендаций для ретаргеинга.
     * Включает в себя интересы, поведенческие признаки и хосты.
     *
     * @param text - фраза для поиска
     * @param scope - категория кампаний, для которой ищем сегменты (cpc или cpm)
     * @param locale - локаль пользователя, в рамках которой будет происходить поиск интересов.
     * Например, если у пользователя языковые настройки "ru", а входная срока "Cat",
     * результат будет включать только хосты. Если null, то поиск не будет учитывать языковые настройки.
     *
     * @return список [TItem]
     */
    fun getSuggestRules(text: String,
                        scope: CryptaSuggestCampaignType = CryptaSuggestCampaignType.ALL,
                        locale: Locale? = null): List<TItem>

    /**
     * Получает список хостов с крипты по соответсвующим айдишникам, если таковы присутствуют.
     * В случае переданного null - возвращает пустой список
     *
     * @param ids - айдишники хостов
     *
     * @return список [TItem]
     */
    fun getHostsByIds(ids: List<Long>?): List<TItem>
}
