package ru.yandex.direct.crypta.client.impl

import java.util.Locale
import ru.yandex.crypta.siberia.bin.custom_audience.suggester.grpc.TItem
import ru.yandex.direct.crypta.client.CryptaClient
import java.util.concurrent.ConcurrentHashMap
import ru.yandex.direct.crypta.client.model.CryptaSuggestCampaignType

/**
 * Заглушка для {@link CryptaClient}
 */
class CryptaClientStub: CryptaClient {
    private var hostIds = ConcurrentHashMap.newKeySet<Long>()

    fun addHosts(ids: List<Long>) {
        this.hostIds.addAll(this.hostIds.union(ids))
    }

    init {
        hostIds.add(19_000_000_000L)
    }

    companion object {
        private fun createHostItem(id: Long, name: String) = TItem.newBuilder()
            .setHostId(id)
            .setText(name)
            .build()

        private fun createHostItem(id: Long) = createHostItem(id, "yandex$id.ru")
    }

    override fun getSuggestRules(text: String, scope: CryptaSuggestCampaignType, locale: Locale?): List<TItem> = listOf()

    override fun getHostsByIds(ids: List<Long>?): List<TItem> = ids.orEmpty()
        .intersect(this.hostIds.toSet())
        .map { createHostItem(it) }
}
