package ru.yandex.direct.crypta.client.impl

import NCrypta.NSiberia.NCustomAudience.NSuggester.NRawData.Segment.TExport.ECampaignType
import io.grpc.ManagedChannelBuilder
import ru.yandex.crypta.siberia.bin.custom_audience.suggester.grpc.TGetHostsRequest
import ru.yandex.crypta.siberia.bin.custom_audience.suggester.grpc.TItem
import ru.yandex.crypta.siberia.bin.custom_audience.suggester.grpc.TSuggestRequest
import ru.yandex.crypta.siberia.bin.custom_audience.suggester.grpc.TSuggesterServiceGrpc
import ru.yandex.direct.crypta.client.CryptaClient
import ru.yandex.direct.utils.HostPort
import java.util.Locale
import ru.yandex.direct.crypta.client.model.CryptaSuggestCampaignType

/**
 * Реализация {@link CryptaClient} через GRPC
 */
class GrpcCryptaClient(address: HostPort) : CryptaClient {

    companion object {
        private const val LIMIT = 30L

        private fun createGetHostRequest(ids: List<Long>) = TGetHostsRequest.newBuilder()
            .addAllHostIds(ids)
            .build()

        private fun convertToECampaignType(scope: CryptaSuggestCampaignType) =
            ECampaignType.forNumber(scope.typedValue) ?: ECampaignType.all
    }

    private val suggesterServiceGrpc: TSuggesterServiceGrpc.TSuggesterServiceBlockingStub

    init {
        val channel = ManagedChannelBuilder
            .forAddress(address.host, address.port)
            .usePlaintext()
            .build()
        suggesterServiceGrpc = TSuggesterServiceGrpc.newBlockingStub(channel)
    }

    override fun getSuggestRules(text: String, scope: CryptaSuggestCampaignType, locale: Locale?): List<TItem> {
        val requestBuilder = TSuggestRequest.newBuilder()
            .setText(text)
            .setLimit(LIMIT)
            .setCampaignType(convertToECampaignType(scope))

        locale?.let { requestBuilder.setLocale(it.language) }


        return suggesterServiceGrpc.suggest(requestBuilder.build()).itemsList
    }

    override fun getHostsByIds(ids: List<Long>?): List<TItem> = when {
        ids.isNullOrEmpty() -> emptyList()
        else -> suggesterServiceGrpc.getHosts(createGetHostRequest(ids)).itemsList
    }
}
