package ru.yandex.direct.libs.curator;

import java.util.List;

import javax.annotation.Nullable;

import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.data.Stat;

/**
 * Обертка над CuratorFramework с приведением checked-исключений в Runtime.
 */
public class CuratorWrapper {
    private final CuratorFramework client;

    public CuratorWrapper(CuratorFramework curatorFramework) {
        this.client = curatorFramework;
    }

    /**
     * Получить строку, идентифицирующую текущее подключение к ZooKeeper
     *
     * @return строка со списком серверов/портов
     */
    public String getConnectionsString() {
        return client.getZookeeperClient().getCurrentConnectionString();
    }

    /**
     * Получить список дочерних нод
     *
     * @param path нода для получения списка
     * @return список нод
     */
    public List<String> getChildrenForPath(String path) {
        try {
            return client.getChildren().forPath(path);
        } catch (Exception e) {
            throw new CuratorRuntimeException(e);
        }
    }

    /**
     * Получить статистику по ноде
     *
     * @param path нода для получения статистики
     * @return новый инстанс {@link Stat} или {@code null}, если нода не существует
     */
    @Nullable
    public Stat getStatForPath(String path) {
        try {
            return client.checkExists().forPath(path);
        } catch (Exception e) {
            throw new CuratorRuntimeException(e);
        }
    }
}
