package ru.yandex.direct.currency;

import java.math.BigDecimal;

import javax.annotation.Generated;

/**
 * Константы и параметры валюты
 *
 * @see <a href="/direct/perl/protected/Currencies.pm">Currencies</a>
 */
@Generated(
        value = "ru.yandex.direct.currencyimporter.CurrencyImporter",
        date = "2022-05-30",
        comments = "generated from http://8531.beta1.direct.yandex.ru/CurrenciesList"
)
public interface Currency {
    /**
     * шаг торгов
     */
    @ConstantDescription("шаг торгов")
    BigDecimal getAuctionStep();

    /**
     * Подсветка средней цены конверсии в стратегии "Средняя цена конверсии"
     */
    @ConstantDescription("Подсветка средней цены конверсии в стратегии \"Средняя цена конверсии\"")
    BigDecimal getAutobudgetAvgCpaWarning();

    /**
     * Подсветка средней цены клика в стратегии "Средняя цена клика"
     */
    @ConstantDescription("Подсветка средней цены клика в стратегии \"Средняя цена клика\"")
    BigDecimal getAutobudgetAvgPriceWarning();

    /**
     * Подсветка количества кликов для стратегии "пакет кликов"
     */
    @ConstantDescription("Подсветка количества кликов для стратегии \"пакет кликов\"")
    int getAutobudgetClicksBundleWarning();

    /**
     * Подсветка максимальной ставки в автоматических стратегиях
     */
    @ConstantDescription("Подсветка максимальной ставки в автоматических стратегиях")
    BigDecimal getAutobudgetMaxPriceWarning();

    /**
     * Подсветка средней цены конверсии в стратегии "Средняя цена конверсии" в режиме "Оплата за конверсии"
     */
    @ConstantDescription("Подсветка средней цены конверсии в стратегии \"Средняя цена конверсии\" в режиме \"Оплата " +
            "за конверсии\"")
    BigDecimal getAutobudgetPayForConversionAvgCpaWarning();

    /**
     * Подсветка средней цены конверсии в стратегии "Средняя цена конверсии" в режиме "Оплата за конверсии"
     */
    @ConstantDescription("Подсветка средней цены конверсии в стратегии \"Средняя цена конверсии\" в режиме \"Оплата " +
            "за конверсии\"")
    BigDecimal getAutobudgetPayForConversionAvgCpaWarningIncreased();

    /**
     * Подсветка недельного бюджета в автоматических стратегиях
     */
    @ConstantDescription("Подсветка недельного бюджета в автоматических стратегиях")
    BigDecimal getAutobudgetSumWarning();

    /**
     * символьный код валюты в Балансе
     */
    @ConstantDescription("символьный код валюты в Балансе")
    String getBalanceCurrencyName();

    /**
     * Подсветка больших значений ставок
     */
    @ConstantDescription("Подсветка больших значений ставок")
    BigDecimal getBigRate();

    /**
     * порог бюджета для Brand Lift-а
     */
    @ConstantDescription("порог бюджета для Brand Lift-а")
    BigDecimal getBrandSurveyBudgetThreshold();

    /**
     * порог ежедневного бюджета для Band Lift-а
     */
    @ConstantDescription("порог ежедневного бюджета для Band Lift-а")
    BigDecimal getBrandSurveyBudgetThresholdDaily();

    /**
     * код валюты
     */
    @ConstantDescription("код валюты")
    CurrencyCode getCode();

    /**
     * умолчальная сумма недельного автобюджета
     */
    @ConstantDescription("умолчальная сумма недельного автобюджета")
    BigDecimal getDefaultAutobudget();

    /**
     * дефолтная цена за просмотр
     */
    @ConstantDescription("дефолтная цена за просмотр")
    BigDecimal getDefaultAvgCpv();

    /**
     * дефолтная цена за тыс. показов
     */
    @ConstantDescription("дефолтная цена за тыс. показов")
    BigDecimal getDefaultCpmPrice();

    /**
     * умолчальная ставка
     */
    @ConstantDescription("умолчальная ставка")
    BigDecimal getDefaultPrice();

    /**
     * умолчальная подсказка платежа
     */
    @ConstantDescription("умолчальная подсказка платежа")
    BigDecimal getDirectDefaultPay();

    /**
     * числовой код валюты
     */
    @ConstantDescription("числовой код валюты")
    Integer getIsoNumCode();

    /**
     * Число, показывающее порядок валюты в списке валют
     */
    @ConstantDescription("Число, показывающее порядок валюты в списке валют")
    int getListOrder();

    /**
     * максимальная сумма недельного автобюджета
     */
    @ConstantDescription("максимальная сумма недельного автобюджета")
    BigDecimal getMaxAutobudget();

    /**
     * максимальная допустимая ставка для автобюджета
     */
    @ConstantDescription("максимальная допустимая ставка для автобюджета")
    BigDecimal getMaxAutobudgetBid();

    /**
     * максимальное количество кликов для стратегии "Пакет кликов"
     */
    @ConstantDescription("максимальное количество кликов для стратегии \"Пакет кликов\"")
    long getMaxAutobudgetClicksBundle();

    /**
     * максимальная сумма платежа пластиковой картой
     */
    @ConstantDescription("максимальная сумма платежа пластиковой картой")
    BigDecimal getMaxAutopayCard();

    /**
     * максимальная сумма остатка на счете для автоплатежа
     */
    @ConstantDescription("максимальная сумма остатка на счете для автоплатежа")
    BigDecimal getMaxAutopayRemaining();

    /**
     * максимальная сумма платежа Яндекс.Деньгами
     */
    @ConstantDescription("максимальная сумма платежа Яндекс.Деньгами")
    BigDecimal getMaxAutopayYamoney();

    /**
     * максимальная цена за просмотр
     */
    @ConstantDescription("максимальная цена за просмотр")
    BigDecimal getMaxAvgCpv();

    /**
     * максимально допустимый оскаток для архивации клиента
     */
    @ConstantDescription("максимально допустимый оскаток для архивации клиента")
    BigDecimal getMaxClientArchive();

    /**
     * максимальная цена за тыс. показов
     */
    @ConstantDescription("максимальная цена за тыс. показов")
    BigDecimal getMaxCpmPrice();

    /**
     * максимальная сумма дневного бюджета
     */
    @ConstantDescription("максимальная сумма дневного бюджета")
    BigDecimal getMaxDailyBudgetAmount();

    /**
     * максимальная сумма бюджета на фиксированный период
     */
    @ConstantDescription("максимальная сумма бюджета на фиксированный период")
    BigDecimal getMaxDailyBudgetForPeriod();

    /**
     * максимальная ставка
     */
    @ConstantDescription("максимальная ставка")
    BigDecimal getMaxPrice();

    /**
     * максимальная отображаемая ставка из торгов
     */
    @ConstantDescription("максимальная отображаемая ставка из торгов")
    BigDecimal getMaxShowBid();

    /**
     * максимальная сумма счета, которую можем подсказать на странице оплаты
     */
    @ConstantDescription("максимальная сумма счета, которую можем подсказать на странице оплаты")
    BigDecimal getMaxTopaySuggest();

    /**
     * значение промежуточного деления на шлкале прогноза цены за просмотр
     */
    @ConstantDescription("значение промежуточного деления на шлкале прогноза цены за просмотр")
    BigDecimal getMiddleAvgCpv();

    /**
     * минимальная сумма недельного автобюджета
     */
    @ConstantDescription("минимальная сумма недельного автобюджета")
    BigDecimal getMinAutobudget();

    /**
     * минимальная ставка для стратегии "Средняя цена конверсии"
     */
    @ConstantDescription("минимальная ставка для стратегии \"Средняя цена конверсии\"")
    BigDecimal getMinAutobudgetAvgCpa();

    /**
     * минимальная средняя цена за тыс показов
     */
    @ConstantDescription("минимальная средняя цена за тыс показов")
    BigDecimal getMinAutobudgetAvgCpm();

    /**
     * минимальная ставка для стратегии "Средняя цена клика"
     */
    @ConstantDescription("минимальная ставка для стратегии \"Средняя цена клика\"")
    BigDecimal getMinAutobudgetAvgPrice();

    /**
     * минимальная ставка для автобюджета
     */
    @ConstantDescription("минимальная ставка для автобюджета")
    BigDecimal getMinAutobudgetBid();

    /**
     * минимальное количество кликов для стратегии "Пакет кликов"
     */
    @ConstantDescription("минимальное количество кликов для стратегии \"Пакет кликов\"")
    int getMinAutobudgetClicksBundle();

    /**
     * минимальная сумма платежа в автопополнении
     */
    @ConstantDescription("минимальная сумма платежа в автопополнении")
    BigDecimal getMinAutopay();

    /**
     * минимальная цена за просмотр
     */
    @ConstantDescription("минимальная цена за просмотр")
    BigDecimal getMinAvgCpv();

    /**
     * минимальная цена CPC/CPA для смарт баннеров
     */
    @ConstantDescription("минимальная цена CPC/CPA для смарт баннеров")
    BigDecimal getMinCpcCpaPerformance();

    /**
     * минимальная цена за тыс. показов на главной
     */
    @ConstantDescription("минимальная цена за тыс. показов на главной")
    BigDecimal getMinCpmFrontpagePrice();

    /**
     * минимальная цена за тыс. показов
     */
    @ConstantDescription("минимальная цена за тыс. показов")
    BigDecimal getMinCpmPrice();

    /**
     * минимальная сумма бюджета на фиксированный период
     */
    @ConstantDescription("минимальная сумма бюджета на фиксированный период")
    BigDecimal getMinDailyBudgetForPeriod();

    /**
     * минимальная сумма дневного бюджета
     */
    @ConstantDescription("минимальная сумма дневного бюджета")
    BigDecimal getMinDayBudget();

    /**
     * минимальная цена за клик, при которой может быть показана картинка
     */
    @ConstantDescription("минимальная цена за клик, при которой может быть показана картинка")
    BigDecimal getMinImagePrice();

    /**
     * минимальный платёж
     */
    @ConstantDescription("минимальный платёж")
    BigDecimal getMinPay();

    /**
     * минимальная ставка
     */
    @ConstantDescription("минимальная ставка")
    BigDecimal getMinPrice();

    /**
     * ограничения ставок для МФА-сайтов
     */
    @ConstantDescription("ограничения ставок для МФА-сайтов")
    BigDecimal getMinPriceForMfa();

    /**
     * Минимальная сумма пополнения, начиная с которой мы интерпретируем пополнение как платеж
     */
    @ConstantDescription("Минимальная сумма пополнения, начиная с которой мы интерпретируем пополнение как платеж")
    BigDecimal getMinSumInterpreteAsPayment();

    /**
     * минимальная сумма для переноса с кампании на кампанию
     */
    @ConstantDescription("минимальная сумма для переноса с кампании на кампанию")
    BigDecimal getMinTransferMoney();

    /**
     * минимальная сумма дневного бюджета общего счета
     */
    @ConstantDescription("минимальная сумма дневного бюджета общего счета")
    BigDecimal getMinWalletDayBudget();

    /**
     * Максимальное значение для средней точки баблометра
     */
    @ConstantDescription("Максимальное значение для средней точки баблометра")
    BigDecimal getMoneymeterMaxMiddleSum();

    /**
     * Минимальная ставка для средней цены баблометра
     */
    @ConstantDescription("Минимальная ставка для средней цены баблометра")
    BigDecimal getMoneymeterMiddlePriceMin();

    /**
     * Начало типичного интервала для средних позиций баблометра
     */
    @ConstantDescription("Начало типичного интервала для средних позиций баблометра")
    BigDecimal getMoneymeterTypicalMiddleSumIntervalBegin();

    /**
     * Конец типичного интервала для средних позиций баблометра
     */
    @ConstantDescription("Конец типичного интервала для средних позиций баблометра")
    BigDecimal getMoneymeterTypicalMiddleSumIntervalEnd();

    /**
     * порог отправки уведомлений об окончании средств
     */
    @ConstantDescription("порог отправки уведомлений об окончании средств")
    BigDecimal getMoneyOutLimit();

    /**
     * минимальный остаток на счёте для CPA
     */
    @ConstantDescription("минимальный остаток на счёте для CPA")
    BigDecimal getPayForConversionMinReservedSumDefaultValue();

    /**
     * максимально допустимая сумма платежа наличными
     */
    @ConstantDescription("максимально допустимая сумма платежа наличными")
    BigDecimal getPayWithCashLimit();

    /**
     * Количество значащих знаков после запятой в суммах
     */
    @ConstantDescription("Количество значащих знаков после запятой в суммах")
    int getPrecisionDigitCount();

    /**
     * рекомендуемая сумма оплаты
     */
    @ConstantDescription("рекомендуемая сумма оплаты")
    BigDecimal getRecommendationSumMax();

    /**
     * средняя рекомендуемая сумма оплаты
     */
    @ConstantDescription("средняя рекомендуемая сумма оплаты")
    BigDecimal getRecommendationSumMid();

    /**
     * минимально рекомендуемая сумма оплаты
     */
    @ConstantDescription("минимально рекомендуемая сумма оплаты")
    BigDecimal getRecommendationSumMin();

    /**
     * сумма, при которой нужно предупреждать пользователя о методах оплаты (только для рублей)
     */
    @ConstantDescription("сумма, при которой нужно предупреждать пользователя о методах оплаты (только для рублей)")
    BigDecimal getRecommendationSumWarn();

    /**
     * рекомендуемая сумма оплаты (без использования грубого прогноза)
     */
    @ConstantDescription("рекомендуемая сумма оплаты (без использования грубого прогноза)")
    BigDecimal getRecommendedSumToPay();

    /**
     * первая сумма недельного бюджета для тачевого интерфейса
     */
    @ConstantDescription("первая сумма недельного бюджета для тачевого интерфейса")
    BigDecimal getTouchWeekBudgetSumFirst();

    /**
     * вторая сумма недельного бюджета для тачевого интерфейса
     */
    @ConstantDescription("вторая сумма недельного бюджета для тачевого интерфейса")
    BigDecimal getTouchWeekBudgetSumSecond();

    /**
     * третья сумма недельного бюджета для тачевого интерфейса
     */
    @ConstantDescription("третья сумма недельного бюджета для тачевого интерфейса")
    BigDecimal getTouchWeekBudgetSumThird();

    /**
     * дефолтное значение ConversionValue для uc
     */
    @ConstantDescription("дефолтное значение ConversionValue для uc")
    BigDecimal getUcDefaultConversionValue();

    /**
     * дефолтный недельный бюджет для uc
     */
    @ConstantDescription("дефолтный недельный бюджет для uc")
    BigDecimal getUcDefaultWeekBudget();

    /**
     * дефолтный недельный бюджет для ecom uc
     */
    @ConstantDescription("дефолтный недельный бюджет для ecom uc")
    BigDecimal getEcomUcDefaultWeekBudget();

    /**
     * Делитель для сумм в БК - //home/yabs/dict/Currency.Ratio
     */
    @ConstantDescription("Делитель для сумм в БК - //home/yabs/dict/Currency.Ratio")
    int getYabsRatio();
}
