package ru.yandex.direct.currency;

import ru.yandex.direct.i18n.Translatable;

/**
 * Текстовое представление валюты, содержит сокращенное название и полное
 */
public class CurrencyTranslation {
    private final Translatable shortForm;
    private final Translatable longForm;
    private final Translatable symbol;

    public CurrencyTranslation(Translatable shortForm, Translatable longForm, Translatable symbol) {
        this.shortForm = shortForm;
        this.longForm = longForm;
        this.symbol = symbol;
    }

    public Translatable shortForm() {
        return shortForm;
    }

    public Translatable longForm() {
        return longForm;
    }

    public Translatable symbol() {
        return symbol;
    }
}
