package ru.yandex.direct.currency;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;

import javax.annotation.Generated;

import com.google.common.collect.ImmutableList;

/**
 * Курсы валют
 */
@Generated(
        value = "ru.yandex.direct.currencyimporter.CurrencyImporter",
        date = "2021-09-05",
        comments = "generated from http://8841.beta1.direct.yandex.ru/jsonrpc/CurrencyRates?method=get_YND_FIXED_rates"
)
public class FixedRates {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.BASIC_ISO_DATE;

    static final LocalDate BEGIN_OF_TIME = LocalDate.ofEpochDay(0);

    static final Rate ONE = new Rate(BEGIN_OF_TIME, 1, 1);

    static final List<Rate> BYN_HISTORY = ImmutableList.copyOf(new Rate[]{
            new Rate(BEGIN_OF_TIME, 0.8, 0.8),
    });

    static final List<Rate> CHF_HISTORY = ImmutableList.copyOf(new Rate[]{
            new Rate(BEGIN_OF_TIME, 0.77, 0.77),
            new Rate(LocalDate.parse("20141201", DATE_FORMAT), 0.57, 0.53),
            new Rate(LocalDate.parse("20150401", DATE_FORMAT), 0.41, 0.41),
    });

    static final List<Rate> EUR_HISTORY = ImmutableList.copyOf(new Rate[]{
            new Rate(BEGIN_OF_TIME, 0.65, 0.65),
            new Rate(LocalDate.parse("20141201", DATE_FORMAT), 0.45, 0.45),
            new Rate(LocalDate.parse("20150401", DATE_FORMAT), 0.39, 0.39),
    });

    static final List<Rate> KZT_HISTORY = ImmutableList.copyOf(new Rate[]{
            new Rate(BEGIN_OF_TIME, 145.6, 130),
            new Rate(LocalDate.parse("20141201", DATE_FORMAT), 112, 100),
            new Rate(LocalDate.parse("20150401", DATE_FORMAT), 84, 75),
            new Rate(LocalDate.parse("20150701", DATE_FORMAT), 112, 100),
            new Rate(LocalDate.parse("20151001", DATE_FORMAT), 117.6, 105),
    });

    static final List<Rate> RUB_HISTORY = ImmutableList.copyOf(new Rate[]{
            new Rate(BEGIN_OF_TIME, 30, 25.4237288135593),
    });

    static final List<Rate> TRY_HISTORY = ImmutableList.copyOf(new Rate[]{
            new Rate(BEGIN_OF_TIME, 2, 1.7),
            new Rate(LocalDate.parse("20141201", DATE_FORMAT), 1.42, 1.2),
            new Rate(LocalDate.parse("20150401", DATE_FORMAT), 1.26, 1.07),
    });

    static final List<Rate> UAH_HISTORY = ImmutableList.copyOf(new Rate[]{
            new Rate(BEGIN_OF_TIME, 6, 5),
            new Rate(LocalDate.parse("20121201", DATE_FORMAT), 8.1, 6.75),
            new Rate(LocalDate.parse("20140901", DATE_FORMAT), 12, 10),
    });

    static final List<Rate> USD_HISTORY = ImmutableList.copyOf(new Rate[]{
            new Rate(BEGIN_OF_TIME, 0.85, 0.85),
            new Rate(LocalDate.parse("20141201", DATE_FORMAT), 0.56, 0.56),
            new Rate(LocalDate.parse("20150401", DATE_FORMAT), 0.41, 0.41),
    });

    static final List<Rate> GBP_HISTORY = ImmutableList.copyOf(new Rate[]{
            new Rate(BEGIN_OF_TIME, 0.85, 0.85),
            new Rate(LocalDate.parse("20141201", DATE_FORMAT), 0.56, 0.56),
            new Rate(LocalDate.parse("20150401", DATE_FORMAT), 0.41, 0.41),
    });
}
