package ru.yandex.direct.currency;

import java.util.function.Function;

/**
 * Конвертер микроденег в {@link Money} с округлением.
 */
public abstract class MicroMoneyConverter implements Function<Long, Money> {
    final CurrencyCode currencyCode;

    private MicroMoneyConverter(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public static MicroMoneyConverter roundingUp(CurrencyCode currencyCode) {
        return new RoundingUp(currencyCode);
    }

    private static class RoundingUp extends MicroMoneyConverter {

        private RoundingUp(CurrencyCode currencyCode) {
            super(currencyCode);
        }

        @Override
        public Money apply(Long micros) {
            return Money.valueOfMicros(micros, currencyCode).roundToAuctionStepUp();
        }
    }
}

