package ru.yandex.direct.currency;

import java.time.LocalDate;
import java.util.Objects;

/**
 * Курс валюты
 */
public class Rate implements Comparable<Rate> {
    private LocalDate date;

    private double withVAT;

    private double withoutVAT;

    public Rate(LocalDate date, double withVAT, double withoutVAT) {
        this.date = date;
        this.withVAT = withVAT;
        this.withoutVAT = withoutVAT;
    }

    /**
     * @return {@link LocalDate}
     * Дата, начиная с которой действует этот курс
     */
    public LocalDate getDate() {
        return date;
    }

    /**
     * @return {double}
     * курс с НДС
     */
    public double getWithVAT() {
        return withVAT;
    }

    /**
     * @return {double}
     * курс без НДС
     */
    public double getWithoutVAT() {
        return withoutVAT;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ru.yandex.direct.currency.Rate{");
        sb.append("date=").append(date);
        sb.append("withVAT=").append(withVAT);
        sb.append(", withoutVAT=").append(withoutVAT);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Rate that = (Rate) o;
        return Objects.equals(date, that.date)
                && Objects.equals(withVAT, that.withVAT)
                && Objects.equals(withoutVAT, that.withoutVAT);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
                date,
                withVAT,
                withoutVAT
        );
    }

    /**
     * сравниваются только даты
     */
    @Override
    public int compareTo(Rate o) {
        return this.date.compareTo(o.date);
    }
}
