package ru.yandex.direct.currency.currencies;

import java.math.BigDecimal;

import javax.annotation.Generated;

import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.currency.CurrencyCode;

/**
 * Константы и параметры валюты RUB
 */
@Generated(
        value = "ru.yandex.direct.currencyimporter.CurrencyImporter",
        date = "2022-05-30",
        comments = "generated from http://8531.beta1.direct.yandex.ru/CurrenciesList"
)
public class CurrencyRub implements Currency {
    private static final CurrencyRub INSTANCE = new CurrencyRub();

    private static final BigDecimal AUCTION_STEP = new BigDecimal("0.1");

    private static final BigDecimal AUTOBUDGET_AVG_CPA_WARNING = new BigDecimal("30000");

    private static final BigDecimal AUTOBUDGET_AVG_PRICE_WARNING = new BigDecimal("300");

    private static final int AUTOBUDGET_CLICKS_BUNDLE_WARNING = 10000000;

    private static final BigDecimal AUTOBUDGET_MAX_PRICE_WARNING = new BigDecimal("300");

    private static final BigDecimal AUTOBUDGET_PAY_FOR_CONVERSION_AVG_CPA_WARNING = new BigDecimal("5000");

    private static final BigDecimal AUTOBUDGET_PAY_FOR_CONVERSION_AVG_CPA_WARNING_INCREASED = new BigDecimal("15000");

    private static final BigDecimal AUTOBUDGET_SUM_WARNING = new BigDecimal("1000000");

    private static final String BALANCE_CURRENCY_NAME = null;

    private static final BigDecimal BIG_RATE = new BigDecimal("300");

    private static final BigDecimal BRAND_SURVEY_BUDGET_THRESHOLD = new BigDecimal("1000000");

    private static final BigDecimal BRAND_SURVEY_BUDGET_THRESHOLD_DAILY = new BigDecimal("70000");

    private static final CurrencyCode CURRENCY_CODE = CurrencyCode.RUB;

    private static final BigDecimal DEFAULT_AUTOBUDGET = new BigDecimal("1500");

    private static final BigDecimal DEFAULT_AVG_CPV = new BigDecimal("0.6");

    private static final BigDecimal DEFAULT_CPM_PRICE = new BigDecimal("100");

    private static final BigDecimal DEFAULT_PRICE = new BigDecimal("3");

    private static final BigDecimal DIRECT_DEFAULT_PAY = new BigDecimal("1500");

    private static final Integer ISO_NUM_CODE = 643;

    private static final int LIST_ORDER = 2;

    private static final BigDecimal MAX_AUTOBUDGET = new BigDecimal("300000000");

    private static final BigDecimal MAX_AUTOBUDGET_BID = new BigDecimal("25000");

    private static final long MAX_AUTOBUDGET_CLICKS_BUNDLE = 1000000000L;

    private static final BigDecimal MAX_AUTOPAY_CARD = new BigDecimal("49999.99");

    private static final BigDecimal MAX_AUTOPAY_REMAINING = new BigDecimal("999999.99");

    private static final BigDecimal MAX_AUTOPAY_YAMONEY = new BigDecimal("15000");

    private static final BigDecimal MAX_AVG_CPV = new BigDecimal("2");

    private static final BigDecimal MAX_CLIENT_ARCHIVE = new BigDecimal("3000");

    private static final BigDecimal MAX_CPM_PRICE = new BigDecimal("3000");

    private static final BigDecimal MAX_DAILY_BUDGET_AMOUNT = new BigDecimal("1000000000");

    private static final BigDecimal MAX_DAILY_BUDGET_FOR_PERIOD = new BigDecimal("100000000");

    private static final BigDecimal MAX_PRICE = new BigDecimal("25000");

    private static final BigDecimal MAX_SHOW_BID = new BigDecimal("5000");

    private static final BigDecimal MAX_TOPAY_SUGGEST = new BigDecimal("15000");

    private static final BigDecimal MIDDLE_AVG_CPV = new BigDecimal("1.2");

    private static final BigDecimal MIN_AUTOBUDGET = new BigDecimal("300");

    private static final BigDecimal MIN_AUTOBUDGET_AVG_CPA = new BigDecimal("0.9");

    private static final BigDecimal MIN_AUTOBUDGET_AVG_CPM = new BigDecimal("5");

    private static final BigDecimal MIN_AUTOBUDGET_AVG_PRICE = new BigDecimal("0.9");

    private static final BigDecimal MIN_AUTOBUDGET_BID = new BigDecimal("0.3");

    private static final int MIN_AUTOBUDGET_CLICKS_BUNDLE = 100;

    private static final BigDecimal MIN_AUTOPAY = new BigDecimal("300");

    private static final BigDecimal MIN_AVG_CPV = new BigDecimal("0.1");

    private static final BigDecimal MIN_CPC_CPA_PERFORMANCE = new BigDecimal("1");

    private static final BigDecimal MIN_CPM_FRONTPAGE_PRICE = new BigDecimal("25");

    private static final BigDecimal MIN_CPM_PRICE = new BigDecimal("5");

    private static final BigDecimal MIN_DAILY_BUDGET_FOR_PERIOD = new BigDecimal("300");

    private static final BigDecimal MIN_DAY_BUDGET = new BigDecimal("300");

    private static final BigDecimal MIN_IMAGE_PRICE = new BigDecimal("0.3");

    private static final BigDecimal MIN_PAY = new BigDecimal("300");

    private static final BigDecimal MIN_PRICE = new BigDecimal("0.3");

    private static final BigDecimal MIN_PRICE_FOR_MFA = new BigDecimal("1.5");

    private static final BigDecimal MIN_SUM_INTERPRETE_AS_PAYMENT = new BigDecimal("300");

    private static final BigDecimal MIN_TRANSFER_MONEY = new BigDecimal("300");

    private static final BigDecimal MIN_WALLET_DAY_BUDGET = new BigDecimal("1000");

    private static final BigDecimal MONEYMETER_MAX_MIDDLE_SUM = new BigDecimal("13000");

    private static final BigDecimal MONEYMETER_MIDDLE_PRICE_MIN = new BigDecimal("150");

    private static final BigDecimal MONEYMETER_TYPICAL_MIDDLE_SUM_INTERVAL_BEGIN = new BigDecimal("800");

    private static final BigDecimal MONEYMETER_TYPICAL_MIDDLE_SUM_INTERVAL_END = new BigDecimal("1600");

    private static final BigDecimal MONEY_OUT_LIMIT = new BigDecimal("5");

    private static final BigDecimal PAY_FOR_CONVERSION_MIN_RESERVED_SUM_DEFAULT_VALUE = new BigDecimal("5000");

    private static final BigDecimal PAY_WITH_CASH_LIMIT = new BigDecimal("12500");

    private static final int PRECISION_DIGIT_COUNT = 4;

    private static final BigDecimal RECOMMENDATION_SUM_MAX = new BigDecimal("35000");

    private static final BigDecimal RECOMMENDATION_SUM_MID = new BigDecimal("12500");

    private static final BigDecimal RECOMMENDATION_SUM_MIN = new BigDecimal("5000");

    private static final BigDecimal RECOMMENDATION_SUM_WARN = new BigDecimal("249999");

    private static final BigDecimal RECOMMENDED_SUM_TO_PAY = new BigDecimal("4000");

    private static final BigDecimal TOUCH_WEEK_BUDGET_SUM_FIRST = new BigDecimal("1200");

    private static final BigDecimal TOUCH_WEEK_BUDGET_SUM_SECOND = new BigDecimal("2000");

    private static final BigDecimal TOUCH_WEEK_BUDGET_SUM_THIRD = new BigDecimal("3000");

    private static final BigDecimal UC_DEFAULT_CONVERSION_VALUE = new BigDecimal("100");

    private static final BigDecimal UC_DEFAULT_WEEK_BUDGET = new BigDecimal("2300");

    private static final BigDecimal ECOM_UC_DEFAULT_WEEK_BUDGET = new BigDecimal("5000");

    private static final int YABS_RATIO = 100;

    private CurrencyRub() {
    }

    public static CurrencyRub getInstance() {
        return INSTANCE;
    }

    /**
     * шаг торгов
     */
    public BigDecimal getAuctionStep() {
        return AUCTION_STEP;
    }

    /**
     * Подсветка средней цены конверсии в стратегии "Средняя цена конверсии"
     */
    public BigDecimal getAutobudgetAvgCpaWarning() {
        return AUTOBUDGET_AVG_CPA_WARNING;
    }

    /**
     * Подсветка средней цены клика в стратегии "Средняя цена клика"
     */
    public BigDecimal getAutobudgetAvgPriceWarning() {
        return AUTOBUDGET_AVG_PRICE_WARNING;
    }

    /**
     * Подсветка количества кликов для стратегии "пакет кликов"
     */
    public int getAutobudgetClicksBundleWarning() {
        return AUTOBUDGET_CLICKS_BUNDLE_WARNING;
    }

    /**
     * Подсветка максимальной ставки в автоматических стратегиях
     */
    public BigDecimal getAutobudgetMaxPriceWarning() {
        return AUTOBUDGET_MAX_PRICE_WARNING;
    }

    /**
     * Подсветка средней цены конверсии в стратегии "Средняя цена конверсии" в режиме "Оплата за конверсии"
     */
    public BigDecimal getAutobudgetPayForConversionAvgCpaWarning() {
        return AUTOBUDGET_PAY_FOR_CONVERSION_AVG_CPA_WARNING;
    }

    /**
     * Подсветка средней цены конверсии в стратегии "Средняя цена конверсии" в режиме "Оплата за конверсии"
     */
    public BigDecimal getAutobudgetPayForConversionAvgCpaWarningIncreased() {
        return AUTOBUDGET_PAY_FOR_CONVERSION_AVG_CPA_WARNING_INCREASED;
    }

    /**
     * Подсветка недельного бюджета в автоматических стратегиях
     */
    public BigDecimal getAutobudgetSumWarning() {
        return AUTOBUDGET_SUM_WARNING;
    }

    /**
     * символьный код валюты в Балансе
     */
    public String getBalanceCurrencyName() {
        return BALANCE_CURRENCY_NAME;
    }

    /**
     * Подсветка больших значений ставок
     */
    public BigDecimal getBigRate() {
        return BIG_RATE;
    }

    /**
     * порог бюджета для Brand Lift-а
     */
    public BigDecimal getBrandSurveyBudgetThreshold() {
        return BRAND_SURVEY_BUDGET_THRESHOLD;
    }

    /**
     * порог ежедневного бюджета для Band Lift-а
     */
    public BigDecimal getBrandSurveyBudgetThresholdDaily() {
        return BRAND_SURVEY_BUDGET_THRESHOLD_DAILY;
    }

    /**
     * код валюты
     */
    public CurrencyCode getCode() {
        return CURRENCY_CODE;
    }

    /**
     * умолчальная сумма недельного автобюджета
     */
    public BigDecimal getDefaultAutobudget() {
        return DEFAULT_AUTOBUDGET;
    }

    /**
     * дефолтная цена за просмотр
     */
    public BigDecimal getDefaultAvgCpv() {
        return DEFAULT_AVG_CPV;
    }

    /**
     * дефолтная цена за тыс. показов
     */
    public BigDecimal getDefaultCpmPrice() {
        return DEFAULT_CPM_PRICE;
    }

    /**
     * умолчальная ставка
     */
    public BigDecimal getDefaultPrice() {
        return DEFAULT_PRICE;
    }

    /**
     * умолчальная подсказка платежа
     */
    public BigDecimal getDirectDefaultPay() {
        return DIRECT_DEFAULT_PAY;
    }

    /**
     * числовой код валюты
     */
    public Integer getIsoNumCode() {
        return ISO_NUM_CODE;
    }

    /**
     * Число, показывающее порядок валюты в списке валют
     */
    public int getListOrder() {
        return LIST_ORDER;
    }

    /**
     * максимальная сумма недельного автобюджета
     */
    public BigDecimal getMaxAutobudget() {
        return MAX_AUTOBUDGET;
    }

    /**
     * максимальная допустимая ставка для автобюджета
     */
    public BigDecimal getMaxAutobudgetBid() {
        return MAX_AUTOBUDGET_BID;
    }

    /**
     * максимальное количество кликов для стратегии "Пакет кликов"
     */
    public long getMaxAutobudgetClicksBundle() {
        return MAX_AUTOBUDGET_CLICKS_BUNDLE;
    }

    /**
     * максимальная сумма платежа пластиковой картой
     */
    public BigDecimal getMaxAutopayCard() {
        return MAX_AUTOPAY_CARD;
    }

    /**
     * максимальная сумма остатка на счете для автоплатежа
     */
    public BigDecimal getMaxAutopayRemaining() {
        return MAX_AUTOPAY_REMAINING;
    }

    /**
     * максимальная сумма платежа Яндекс.Деньгами
     */
    public BigDecimal getMaxAutopayYamoney() {
        return MAX_AUTOPAY_YAMONEY;
    }

    /**
     * максимальная цена за просмотр
     */
    public BigDecimal getMaxAvgCpv() {
        return MAX_AVG_CPV;
    }

    /**
     * максимально допустимый оскаток для архивации клиента
     */
    public BigDecimal getMaxClientArchive() {
        return MAX_CLIENT_ARCHIVE;
    }

    /**
     * максимальная цена за тыс. показов
     */
    public BigDecimal getMaxCpmPrice() {
        return MAX_CPM_PRICE;
    }

    /**
     * максимальная сумма дневного бюджета
     */
    public BigDecimal getMaxDailyBudgetAmount() {
        return MAX_DAILY_BUDGET_AMOUNT;
    }

    /**
     * максимальная сумма бюджета на фиксированный период
     */
    public BigDecimal getMaxDailyBudgetForPeriod() {
        return MAX_DAILY_BUDGET_FOR_PERIOD;
    }

    /**
     * максимальная ставка
     */
    public BigDecimal getMaxPrice() {
        return MAX_PRICE;
    }

    /**
     * максимальная отображаемая ставка из торгов
     */
    public BigDecimal getMaxShowBid() {
        return MAX_SHOW_BID;
    }

    /**
     * максимальная сумма счета, которую можем подсказать на странице оплаты
     */
    public BigDecimal getMaxTopaySuggest() {
        return MAX_TOPAY_SUGGEST;
    }

    /**
     * значение промежуточного деления на шлкале прогноза цены за просмотр
     */
    public BigDecimal getMiddleAvgCpv() {
        return MIDDLE_AVG_CPV;
    }

    /**
     * минимальная сумма недельного автобюджета
     */
    public BigDecimal getMinAutobudget() {
        return MIN_AUTOBUDGET;
    }

    /**
     * минимальная ставка для стратегии "Средняя цена конверсии"
     */
    public BigDecimal getMinAutobudgetAvgCpa() {
        return MIN_AUTOBUDGET_AVG_CPA;
    }

    /**
     * минимальная средняя цена за тыс показов
     */
    public BigDecimal getMinAutobudgetAvgCpm() {
        return MIN_AUTOBUDGET_AVG_CPM;
    }

    /**
     * минимальная ставка для стратегии "Средняя цена клика"
     */
    public BigDecimal getMinAutobudgetAvgPrice() {
        return MIN_AUTOBUDGET_AVG_PRICE;
    }

    /**
     * минимальная ставка для автобюджета
     */
    public BigDecimal getMinAutobudgetBid() {
        return MIN_AUTOBUDGET_BID;
    }

    /**
     * минимальное количество кликов для стратегии "Пакет кликов"
     */
    public int getMinAutobudgetClicksBundle() {
        return MIN_AUTOBUDGET_CLICKS_BUNDLE;
    }

    /**
     * минимальная сумма платежа в автопополнении
     */
    public BigDecimal getMinAutopay() {
        return MIN_AUTOPAY;
    }

    /**
     * минимальная цена за просмотр
     */
    public BigDecimal getMinAvgCpv() {
        return MIN_AVG_CPV;
    }

    /**
     * минимальная цена CPC/CPA для смарт баннеров
     */
    public BigDecimal getMinCpcCpaPerformance() {
        return MIN_CPC_CPA_PERFORMANCE;
    }

    /**
     * минимальная цена за тыс. показов на главной
     */
    public BigDecimal getMinCpmFrontpagePrice() {
        return MIN_CPM_FRONTPAGE_PRICE;
    }

    /**
     * минимальная цена за тыс. показов
     */
    public BigDecimal getMinCpmPrice() {
        return MIN_CPM_PRICE;
    }

    /**
     * минимальная сумма бюджета на фиксированный период
     */
    public BigDecimal getMinDailyBudgetForPeriod() {
        return MIN_DAILY_BUDGET_FOR_PERIOD;
    }

    /**
     * минимальная сумма дневного бюджета
     */
    public BigDecimal getMinDayBudget() {
        return MIN_DAY_BUDGET;
    }

    /**
     * минимальная цена за клик, при которой может быть показана картинка
     */
    public BigDecimal getMinImagePrice() {
        return MIN_IMAGE_PRICE;
    }

    /**
     * минимальный платёж
     */
    public BigDecimal getMinPay() {
        return MIN_PAY;
    }

    /**
     * минимальная ставка
     */
    public BigDecimal getMinPrice() {
        return MIN_PRICE;
    }

    /**
     * ограничения ставок для МФА-сайтов
     */
    public BigDecimal getMinPriceForMfa() {
        return MIN_PRICE_FOR_MFA;
    }

    /**
     * Минимальная сумма пополнения, начиная с которой мы интерпретируем пополнение как платеж
     */
    public BigDecimal getMinSumInterpreteAsPayment() {
        return MIN_SUM_INTERPRETE_AS_PAYMENT;
    }

    /**
     * минимальная сумма для переноса с кампании на кампанию
     */
    public BigDecimal getMinTransferMoney() {
        return MIN_TRANSFER_MONEY;
    }

    /**
     * минимальная сумма дневного бюджета общего счета
     */
    public BigDecimal getMinWalletDayBudget() {
        return MIN_WALLET_DAY_BUDGET;
    }

    /**
     * Максимальное значение для средней точки баблометра
     */
    public BigDecimal getMoneymeterMaxMiddleSum() {
        return MONEYMETER_MAX_MIDDLE_SUM;
    }

    /**
     * Минимальная ставка для средней цены баблометра
     */
    public BigDecimal getMoneymeterMiddlePriceMin() {
        return MONEYMETER_MIDDLE_PRICE_MIN;
    }

    /**
     * Начало типичного интервала для средних позиций баблометра
     */
    public BigDecimal getMoneymeterTypicalMiddleSumIntervalBegin() {
        return MONEYMETER_TYPICAL_MIDDLE_SUM_INTERVAL_BEGIN;
    }

    /**
     * Конец типичного интервала для средних позиций баблометра
     */
    public BigDecimal getMoneymeterTypicalMiddleSumIntervalEnd() {
        return MONEYMETER_TYPICAL_MIDDLE_SUM_INTERVAL_END;
    }

    /**
     * порог отправки уведомлений об окончании средств
     */
    public BigDecimal getMoneyOutLimit() {
        return MONEY_OUT_LIMIT;
    }

    /**
     * минимальный остаток на счёте для CPA
     */
    public BigDecimal getPayForConversionMinReservedSumDefaultValue() {
        return PAY_FOR_CONVERSION_MIN_RESERVED_SUM_DEFAULT_VALUE;
    }

    /**
     * максимально допустимая сумма платежа наличными
     */
    public BigDecimal getPayWithCashLimit() {
        return PAY_WITH_CASH_LIMIT;
    }

    /**
     * Количество значащих знаков после запятой в суммах
     */
    public int getPrecisionDigitCount() {
        return PRECISION_DIGIT_COUNT;
    }

    /**
     * рекомендуемая сумма оплаты
     */
    public BigDecimal getRecommendationSumMax() {
        return RECOMMENDATION_SUM_MAX;
    }

    /**
     * средняя рекомендуемая сумма оплаты
     */
    public BigDecimal getRecommendationSumMid() {
        return RECOMMENDATION_SUM_MID;
    }

    /**
     * минимально рекомендуемая сумма оплаты
     */
    public BigDecimal getRecommendationSumMin() {
        return RECOMMENDATION_SUM_MIN;
    }

    /**
     * сумма, при которой нужно предупреждать пользователя о методах оплаты (только для рублей)
     */
    public BigDecimal getRecommendationSumWarn() {
        return RECOMMENDATION_SUM_WARN;
    }

    /**
     * рекомендуемая сумма оплаты (без использования грубого прогноза)
     */
    public BigDecimal getRecommendedSumToPay() {
        return RECOMMENDED_SUM_TO_PAY;
    }

    /**
     * первая сумма недельного бюджета для тачевого интерфейса
     */
    public BigDecimal getTouchWeekBudgetSumFirst() {
        return TOUCH_WEEK_BUDGET_SUM_FIRST;
    }

    /**
     * вторая сумма недельного бюджета для тачевого интерфейса
     */
    public BigDecimal getTouchWeekBudgetSumSecond() {
        return TOUCH_WEEK_BUDGET_SUM_SECOND;
    }

    /**
     * третья сумма недельного бюджета для тачевого интерфейса
     */
    public BigDecimal getTouchWeekBudgetSumThird() {
        return TOUCH_WEEK_BUDGET_SUM_THIRD;
    }

    /**
     * дефолтное значение ConversionValue для uc
     */
    public BigDecimal getUcDefaultConversionValue() {
        return UC_DEFAULT_CONVERSION_VALUE;
    }

    /**
     * дефолтный недельный бюджет для uc
     */
    public BigDecimal getUcDefaultWeekBudget() {
        return UC_DEFAULT_WEEK_BUDGET;
    }

    /**
     * дефолтный недельный бюджет для ecom uc
     */
    public BigDecimal getEcomUcDefaultWeekBudget() {
        return ECOM_UC_DEFAULT_WEEK_BUDGET;
    }

    /**
     * Делитель для сумм в БК - //home/yabs/dict/Currency.Ratio
     */
    public int getYabsRatio() {
        return YABS_RATIO;
    }

    @Override
    public String toString() {
        return "Currency{" + getCode() + "}";
    }
}
