package ru.yandex.direct.dialogs.client;

import java.util.List;

import ru.yandex.direct.dialogs.client.model.GetSkillsByUserIdRequest;
import ru.yandex.direct.dialogs.client.model.GetSkillsRequest;
import ru.yandex.direct.dialogs.client.model.Skill;
import ru.yandex.direct.http.smart.annotations.Json;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.http.Body;
import ru.yandex.direct.http.smart.http.Headers;
import ru.yandex.direct.http.smart.http.POST;

public interface Api {
    @POST("/skills/bulk/get")
    @Headers("Content-Type: application/json")
    @Json
    Call<List<Skill>> getSkills(@Body @Json GetSkillsRequest request);

    @POST("/chats/bulk/get")
    @Headers("Content-Type: application/json")
    @Json
    Call<List<List<Skill>>> getSkillsByUserId(@Body @Json GetSkillsByUserIdRequest request);
}
