package ru.yandex.direct.dialogs.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.direct.asynchttp.ParallelFetcherFactory;
import ru.yandex.direct.asynchttp.Result;
import ru.yandex.direct.dialogs.client.model.GetSkillsByUserIdRequest;
import ru.yandex.direct.dialogs.client.model.GetSkillsRequest;
import ru.yandex.direct.dialogs.client.model.Skill;
import ru.yandex.direct.http.smart.core.Smart;
import ru.yandex.direct.tvm.TvmIntegration;
import ru.yandex.direct.tvm.TvmService;

import static com.google.common.collect.Lists.partition;
import static ru.yandex.direct.http.smart.error.ErrorUtils.checkResultForErrors;

public class DialogsClient {
    private final Api api;
    private static final int CHUNK_SIZE = 10; // Органичение со стороны API Диалогов

    public DialogsClient(String url, TvmService tvmService, ParallelFetcherFactory parallelFetcherFactory,
                         TvmIntegration tvmIntegration) {
        api = createApi(url, tvmService, parallelFetcherFactory, tvmIntegration);
    }

    private Api createApi(String url, TvmService tvmService, ParallelFetcherFactory parallelFetcherFactory,
                          TvmIntegration tvmIntegration) {
        return Smart.builder()
                .withParallelFetcherFactory(parallelFetcherFactory)
                .useTvm(tvmIntegration, tvmService)
                .withProfileName("dialogs_api_client")
                .withBaseUrl(url)
                .build()
                .create(Api.class);
    }

    public List<Skill> getSkills(List<String> skillsIds) {
        List<Skill> result = new ArrayList<>();
        for (List<String> chunkSkillsIds : partition(skillsIds, CHUNK_SIZE)) {
            GetSkillsRequest request = new GetSkillsRequest();
            request.setSkillIds(chunkSkillsIds);
            Result<List<Skill>> chunkResult = api.getSkills(request).execute();
            checkResultForErrors(chunkResult, DialogsClientException::new);
            result.addAll(chunkResult.getSuccess());
        }
        return result;
    }

    public Map<Long, List<Skill>> getSkillsByUserId(List<Long> userIds) {
        List<List<Skill>> response = new ArrayList<>();
        for (List<Long> chunkUserIds : partition(userIds, CHUNK_SIZE)) {
            GetSkillsByUserIdRequest request = new GetSkillsByUserIdRequest();
            request.setUserIds(chunkUserIds);
            Result<List<List<Skill>>> chunkResult = api.getSkillsByUserId(request).execute();
            checkResultForErrors(chunkResult, DialogsClientException::new);
            response.addAll(chunkResult.getSuccess());
        }
        Map<Long, List<Skill>> result = new HashMap<>();
        for (int i = 0; i < userIds.size(); i++) {
            List<Skill> skills = response.get(i);
            if (skills == null || skills.isEmpty()) {
                continue;
            }
            result.put(userIds.get(i), skills);
        }
        return result;
    }
}
