package ru.yandex.direct.dialogs.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class Skill {
    @JsonProperty("id")
    private String skillId;
    private String name;
    private String botGuid;
    private Boolean onAir;
    private Error error;

    public Skill() {

    }

    public static class Error {
        Integer code;
        String skillId;
        String message;

        public Error() {

        }

        public Integer getCode() {
            return code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String getSkillId() {
            return skillId;
        }

        public void setSkillId(String skillId) {
            this.skillId = skillId;
        }

        public String getMessage() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Error withCode(Integer code) {
            this.code = code;
            return this;
        }

        public Error withSkillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public Error withMessage(String message) {
            this.message = message;
            return this;
        }

        @Override
        public String toString() {
            return "Skill.Error{" +
                    "skillId=" + skillId +
                    ", code=" + code +
                    ", message=" + message +
                    '}';
        }
    }

    public String getSkillId() {
        return skillId != null ? skillId : error.skillId;
    }

    public void setSkillId(String skillId) {
        this.skillId = skillId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBotGuid() {
        return botGuid;
    }

    public void setBotGuid(String botGuid) {
        this.botGuid = botGuid;
    }

    public Boolean getOnAir() {
        return onAir;
    }

    public void setOnAir(Boolean onAir) {
        this.onAir = onAir;
    }

    public Error getError() {
        return error;
    }

    public void setError(Error error) {
        this.error = error;
    }
}
