package ru.yandex.direct.intapi.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;
import static com.google.common.base.Strings.isNullOrEmpty;

/**
 * Конфигурация для клиента к интапи-ручке Notification
 */
public class IntApiClientConfiguration {
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofSeconds(15);
    private static final Duration DEFAULT_COPY_CAMPAIGNS_READ_TIMEOUT = Duration.ofSeconds(60);

    private URI uri;
    private Duration readTimeout;
    private Duration copyCampaignsReadTimeout;

    public IntApiClientConfiguration(String uri) throws URISyntaxException {
        this(uri, DEFAULT_READ_TIMEOUT, DEFAULT_COPY_CAMPAIGNS_READ_TIMEOUT);
    }

    public IntApiClientConfiguration(
            String uri, Duration readTimeout, Duration copyCampaignsReadTimeout) throws URISyntaxException {
        checkArgument(!isNullOrEmpty(uri));
        checkNotNull(readTimeout);
        checkArgument(!(readTimeout.isNegative() || readTimeout.isZero()));
        checkNotNull(copyCampaignsReadTimeout);
        checkArgument(!(copyCampaignsReadTimeout.isNegative() || copyCampaignsReadTimeout.isZero()));

        this.uri = new URI(uri);
        this.readTimeout = readTimeout;
        this.copyCampaignsReadTimeout = copyCampaignsReadTimeout;
    }

    public URI getUri() {
        return uri;
    }

    public Duration getReadTimeout() {
        return readTimeout;
    }

    public Duration getCopyCampaignsReadTimeout() {
        return copyCampaignsReadTimeout;
    }
}
