package ru.yandex.direct.intapi.client.model.handle;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.intapi.client.IntApiClientException;
import ru.yandex.direct.intapi.client.model.request.IntApiRequest;

import static io.netty.handler.codec.http.HttpHeaderValues.APPLICATION_JSON;
import static ru.yandex.direct.utils.JsonUtils.toJson;

/**
 * Ручка IntApi Директа, запрос к которой делается в JSON, а ответ получается в виде простой строки.
 */
@ParametersAreNonnullByDefault
public class BaseStringJsonIntApiHandle extends IntApiHandle<String> {
    public BaseStringJsonIntApiHandle(String path) {
        super(path, APPLICATION_JSON.toString());
    }

    @Override
    public String serializeRequest(IntApiRequest request) {
        return toJson(request);
    }

    @Override
    public String deserializeResponse(@Nullable String response) {
        if (response == null) {
            throw new IntApiClientException("Received null response");
        }
        return response;
    }
}
