package ru.yandex.direct.intapi.client.model.handle;

import ru.yandex.direct.intapi.client.model.request.IntApiRequest;
import ru.yandex.direct.intapi.client.model.response.bsfront.BsFrontResponse;
import ru.yandex.direct.utils.JsonUtils;

public class BsFrontIntapiHandle extends IntApiHandle<BsFrontResponse> {

    public BsFrontIntapiHandle() {
        super("jsonrpc/BsFront", "application/json");
    }

    @Override
    public String serializeRequest(IntApiRequest request) {
        return JsonUtils.toJson(request);
    }

    @Override
    public BsFrontResponse deserializeResponse(String response) {
        return JsonUtils.fromJson(response, BsFrontResponse.class);
    }
}
