package ru.yandex.direct.intapi.client.model.handle;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.intapi.client.model.request.IntApiRequest;
import ru.yandex.direct.intapi.client.model.response.statistics.CampaignStatisticsResponse;

import static io.netty.handler.codec.http.HttpHeaderValues.APPLICATION_JSON;
import static ru.yandex.direct.utils.JsonUtils.fromJson;
import static ru.yandex.direct.utils.JsonUtils.toJson;

@ParametersAreNonnullByDefault
public class CampaignStatisticsIntApiHandle extends IntApiHandle<CampaignStatisticsResponse> {

    public CampaignStatisticsIntApiHandle(String path) {
        super(path, APPLICATION_JSON.toString());
    }

    @Override
    public String serializeRequest(IntApiRequest request) {
        return toJson(request);
    }

    @Override
    public CampaignStatisticsResponse deserializeResponse(String response) {
        return fromJson(response, CampaignStatisticsResponse.class);
    }
}
