package ru.yandex.direct.intapi.client.model.handle

import io.netty.handler.codec.http.HttpHeaderValues.APPLICATION_JSON
import ru.yandex.direct.intapi.client.model.request.IntApiRequest
import ru.yandex.direct.intapi.client.model.response.CampaignsCopyResponse
import ru.yandex.direct.utils.JsonUtils.toJson
import ru.yandex.direct.utils.fromJson

class CampaignsCopyIntApiHandle(path: String) : IntApiHandle<CampaignsCopyResponse>(path, APPLICATION_JSON.toString()) {
    override fun serializeRequest(request: IntApiRequest): String = toJson(request)
    override fun deserializeResponse(response: String): CampaignsCopyResponse = fromJson(response)
}

