package ru.yandex.direct.intapi.client.model.handle;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.intapi.client.model.request.IntApiRequest;

/**
 * Базовый класс описания ручки IntApi директа для клиента к этой ручке
 */
@ParametersAreNonnullByDefault
public abstract class IntApiHandle<T> {
    private final String path;
    private final String contentType;

    public IntApiHandle(String path, String contentType) {
        this.path = path;
        this.contentType = contentType;
    }

    public String getPath() {
        return path;
    }

    public String getContentType() {
        return contentType;
    }

    /**
     * Вернуть строку с сериализованным представлением запроса к IntApi
     *
     * @param request объект запроса к ручке
     */
    public abstract String serializeRequest(IntApiRequest request);

    /**
     * Вернуть объект с десериализованным ответом ручки
     *
     * @param response строковый ответ
     */
    public abstract T deserializeResponse(String response);
}

