package ru.yandex.direct.intapi.client.model.handle;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JavaType;

import ru.yandex.direct.intapi.client.IntApiClientException;
import ru.yandex.direct.intapi.client.model.request.IntApiRequest;

import static io.netty.handler.codec.http.HttpHeaderValues.APPLICATION_JSON;
import static ru.yandex.direct.utils.JsonUtils.fromJson;
import static ru.yandex.direct.utils.JsonUtils.getTypeFactory;
import static ru.yandex.direct.utils.JsonUtils.toJson;

/**
 * Ручка IntApi Директа, запрос к которой делается в JSON, а ответ получается в виде списка объектов.
 */
@ParametersAreNonnullByDefault
public class ListOfObjectIntApiHandle<T> extends IntApiHandle<List<T>> {
    private final Class<T> responseElementClass;

    public ListOfObjectIntApiHandle(String path, Class<T> responseElementClass) {
        super(path, APPLICATION_JSON.toString());
        this.responseElementClass = responseElementClass;
    }

    @Override
    public String serializeRequest(IntApiRequest request) {
        return toJson(request);
    }

    @Override
    public List<T> deserializeResponse(@Nullable String response) {
        if (response == null) {
            throw new IntApiClientException("Received null response");
        }
        JavaType responseType = getTypeFactory().constructParametricType(List.class, responseElementClass);
        try {
            return fromJson(response, responseType);
        } catch (IllegalArgumentException ex) {
            throw new IntApiClientException("Can not deserialize response", ex);
        }
    }
}
