package ru.yandex.direct.intapi.client.model.handle;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.intapi.client.model.request.IntApiRequest;
import ru.yandex.direct.intapi.client.model.response.PrepareAndValidatePayCampResponse;

import static io.netty.handler.codec.http.HttpHeaderValues.APPLICATION_JSON;
import static ru.yandex.direct.utils.JsonUtils.fromJson;
import static ru.yandex.direct.utils.JsonUtils.toJson;

@ParametersAreNonnullByDefault
public class PrepareAndValidatePayCampIntApiHandle extends IntApiHandle<PrepareAndValidatePayCampResponse> {

    public PrepareAndValidatePayCampIntApiHandle(String path) {
        super(path, APPLICATION_JSON.toString());
    }

    @Override
    public String serializeRequest(IntApiRequest request) {
        return toJson(request);
    }

    @Override
    public PrepareAndValidatePayCampResponse deserializeResponse(String response) {
        return fromJson(response, PrepareAndValidatePayCampResponse.class);
    }
}
