package ru.yandex.direct.intapi.client.model.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Модель данных запроса к интапи-ручке CampaignUnarc
 */
public class CampaignUnarcRequest implements IntApiRequest {

    private static final String UID = "uid";
    private static final String CID = "cid";
    private static final String FORCE = "force";

    @JsonProperty(UID)
    private Long uid;

    @JsonProperty(CID)
    private Long cid;

    @JsonProperty(FORCE)
    private Boolean force;

    @JsonCreator
    public CampaignUnarcRequest(@JsonProperty(UID) Long uid, @JsonProperty(CID) Long cid,
                                @JsonProperty(FORCE) Boolean force) {
        this.uid = uid;
        this.cid = cid;
        this.force = force;
    }

    public Long getUid() {
        return uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public Long getCid() {
        return cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public Boolean getForce() {
        return force;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }
}
