package ru.yandex.direct.intapi.client.model.request;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Модель данных запроса к интапи-ручке Notification
 */
public class NotificationRequest implements IntApiRequest {

    @JsonProperty("name")
    private String notificationType;

    @JsonProperty("vars")
    private Map<String, Object> data;

    @JsonProperty("options")
    private Map<String, Object> options;

    public NotificationRequest(String notificationType, Map<String, Object> data, Map<String, Object> options) {
        this.notificationType = notificationType;
        this.data = data;
        this.options = options;
    }

    public String getNotificationType() {
        return notificationType;
    }

    public void setNotificationType(String notificationType) {
        this.notificationType = notificationType;
    }

    public Map<String, Object> getData() {
        return data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public Map<String, Object> getOptions() {
        return options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }
}
