package ru.yandex.direct.intapi.client.model.request;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonProperty;

public class PayForAllRequest implements IntApiRequest {

    @JsonProperty("role")
    private String role;

    @JsonProperty("login")
    private String login;

    @JsonProperty("requestUrl")
    private String requestUrl;

    @JsonProperty("uid")
    private Long uid;

    @JsonProperty("cid")
    private Long cid;

    @JsonProperty("UID")
    private Long operatorUid;

    @JsonProperty("sum")
    private BigDecimal sum;

    @JsonProperty("with_nds")
    private Boolean withNds;

    @JsonProperty("lang")
    private String language;

    public PayForAllRequest withNds(Boolean withNds) {
        this.withNds = withNds;
        return this;
    }

    public PayForAllRequest withRole(String role) {
        this.role = role;
        return this;
    }

    public PayForAllRequest withLogin(String login) {
        this.login = login;
        return this;
    }

    public PayForAllRequest withRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
        return this;
    }

    public PayForAllRequest withUid(Long uid) {
        this.uid = uid;
        return this;
    }

    public PayForAllRequest withCid(Long cid) {
        this.cid = cid;
        return this;
    }

    public PayForAllRequest withOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid;
        return this;
    }

    public PayForAllRequest withSum(BigDecimal sum) {
        this.sum = sum;
        return this;
    }

    public PayForAllRequest withLanguage(String language) {
        this.language = language;
        return this;
    }

}
