package ru.yandex.direct.intapi.client.model.request.bsfront;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;

import ru.yandex.direct.intapi.client.model.request.IntApiRequest;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class BsFrontRequest implements IntApiRequest {

    @JsonProperty("method")
    private String method;
    @JsonProperty("params")
    private Params params;

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public BsFrontRequest withMethod(String method) {
        this.method = method;
        return this;
    }

    public Params getParams() {
        return params;
    }

    public void setParams(Params params) {
        this.params = params;
    }

    public BsFrontRequest withParams(Params params) {
        this.params = params;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("method", method).append("params", params).toString();
    }

}
