package ru.yandex.direct.intapi.client.model.request.bsfront;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class Params {

    @JsonProperty("operator_uid")
    private Long operatorUid;
    @JsonProperty("client_login")
    private String clientLogin;
    @JsonProperty("creatives")
    private List<Creative> creatives = null;

    public Long getOperatorUid() {
        return operatorUid;
    }

    public void setOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid;
    }

    public Params withOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid;
        return this;
    }

    public String getClientLogin() {
        return clientLogin;
    }

    public void setClientLogin(String clientLogin) {
        this.clientLogin = clientLogin;
    }

    public Params withClientLogin(String clientLogin) {
        this.clientLogin = clientLogin;
        return this;
    }

    public List<Creative> getCreatives() {
        return creatives;
    }

    public void setCreatives(List<Creative> creatives) {
        this.creatives = creatives;
    }

    public Params withCreatives(List<Creative> creatives) {
        this.creatives = creatives;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("operatorUid", operatorUid).append("clientLogin", clientLogin)
                .append("creatives", creatives).toString();
    }

}
