package ru.yandex.direct.intapi.client.model.request.statistics;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.intapi.client.model.request.IntApiRequest;

public class CampaignStatisticsRequest implements IntApiRequest {

    @JsonProperty("uid")
    private Long uid;

    @JsonProperty("UID")
    private Long operatorUid;

    @JsonProperty("report_options")
    private ReportOptions reportOptions;

    @JsonProperty("locale")
    private String locale;

    public CampaignStatisticsRequest withUid(Long uid) {
        this.uid = uid;
        return this;
    }

    public CampaignStatisticsRequest withOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid;
        return this;
    }

    public CampaignStatisticsRequest withReportOptions(ReportOptions reportOptions) {
        this.reportOptions = reportOptions;
        return this;
    }

    public CampaignStatisticsRequest withLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public Long getUid() {
        return uid;
    }

    public CampaignStatisticsRequest setUid(Long uid) {
        this.uid = uid;
        return this;
    }

    public Long getOperatorUid() {
        return operatorUid;
    }

    public CampaignStatisticsRequest setOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid;
        return this;
    }

    public ReportOptions getReportOptions() {
        return reportOptions;
    }

    public CampaignStatisticsRequest setReportOptions(ReportOptions reportOptions) {
        this.reportOptions = reportOptions;
        return this;
    }

    public String getLocale() {
        return locale;
    }

    public CampaignStatisticsRequest setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CampaignStatisticsRequest that = (CampaignStatisticsRequest) o;
        return Objects.equals(uid, that.uid) &&
                Objects.equals(operatorUid, that.operatorUid) &&
                Objects.equals(reportOptions, that.reportOptions) &&
                Objects.equals(locale, that.locale);
    }

    @Override
    public int hashCode() {
        return Objects.hash(uid, operatorUid, reportOptions, locale);
    }
}
