package ru.yandex.direct.intapi.client.model.request.statistics;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class Condition<T> {

    @JsonProperty("eq")
    private T eq;

    @JsonProperty("gt")
    private T gt;

    @JsonProperty("lt")
    private T lt;

    private Condition() {
    }

    public static <T> Condition<T> eq(T eq) {
        var condition = new Condition<T>();
        condition.eq = eq;
        return condition;
    }

    public static <T> Condition<T> gt(T gt) {
        var condition = new Condition<T>();
        condition.gt = gt;
        return condition;
    }

    public static <T> Condition<T> lt(T lt) {
        var condition = new Condition<T>();
        condition.lt = lt;
        return condition;
    }
}
