package ru.yandex.direct.intapi.client.model.response.bsfront;

import java.util.List;
import java.util.StringJoiner;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class BsFrontResponse {

    @JsonProperty("result")
    private List<Result> result = null;
    @JsonProperty("id")
    private Object id;
    @JsonProperty("jsonrpc")
    private String jsonrpc;
    @JsonProperty("errorMessage")
    private String errorMessage;
    @JsonProperty("warningMessage")
    private String warningMessage;

    @JsonProperty("result")
    public List<Result> getResult() {
        return result;
    }

    @JsonProperty("result")
    public void setResult(List<Result> result) {
        this.result = result;
    }

    public BsFrontResponse withResult(List<Result> result) {
        this.result = result;
        return this;
    }

    public Object getId() {
        return id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public BsFrontResponse withId(Object id) {
        this.id = id;
        return this;
    }

    public String getJsonrpc() {
        return jsonrpc;
    }

    public void setJsonrpc(String jsonrpc) {
        this.jsonrpc = jsonrpc;
    }

    public BsFrontResponse withJsonrpc(String jsonrpc) {
        this.jsonrpc = jsonrpc;
        return this;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getWarningMessage() {
        return warningMessage;
    }

    public void setWarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", BsFrontResponse.class.getSimpleName() + "[", "]")
                .add("result=" + result)
                .add("id=" + id)
                .add("jsonrpc='" + jsonrpc + "'")
                .add("errorMessage='" + errorMessage + "'")
                .add("warningMessage='" + warningMessage + "'")
                .toString();
    }
}
