package ru.yandex.direct.intapi.client.model.response.statistics;

import java.time.LocalDate;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

public class CampaignStatisticsItem {

    @JsonProperty("stat_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate date;

    @JsonProperty("stat_date_end")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;

    @JsonProperty("gender")
    private CampaignStatisticsGenderType genderType;

    @JsonProperty("age")
    private CampaignStatisticsAgeType ageType;

    @JsonProperty("region")
    private Integer region;

    @JsonProperty("device_type")
    private CampaignStatisticsDeviceType deviceType;

    @JsonProperty("bid")
    private Long bid;

    @JsonProperty("creative_id")
    private Long creativeId;

    @JsonProperty("search_query")
    private String searchQuery;

    @JsonProperty("shows")
    private Long shows;

    @JsonProperty("shows_a")
    private Long showsA;

    @JsonProperty("shows_b")
    private Long showsB;

    @JsonProperty("shows_absdelta")
    private Long showsAbsDelta;

    @JsonProperty("shows_delta")
    private Double showsPctDelta;

    @JsonProperty("clicks")
    private Long clicks;

    @JsonProperty("clicks_a")
    private Long clicksA;

    @JsonProperty("clicks_b")
    private Long clicksB;

    @JsonProperty("clicks_absdelta")
    private Long clicksAbsDelta;

    @JsonProperty("clicks_delta")
    private Double clicksPctDelta;

    @JsonProperty("agoalnum")
    private Long conversions;

    @JsonProperty("agoalnum_a")
    private Long conversionsA;

    @JsonProperty("agoalnum_b")
    private Long conversionsB;

    @JsonProperty("agoalnum_absdelta")
    private Long conversionsAbsDelta;

    @JsonProperty("agoalnum_delta")
    private Double conversionsPctDelta;

    @JsonProperty("agoalcost")
    private Double costPerConversion;

    @JsonProperty("agoalcost_a")
    private Double costPerConversionA;

    @JsonProperty("agoalcost_b")
    private Double costPerConversionB;

    @JsonProperty("agoalcost_absdelta")
    private Double costPerConversionAbsDelta;

    @JsonProperty("agoalcost_delta")
    private Double costPerConversionPctDelta;

    @JsonProperty("agoalincome")
    private Double revenue;

    @JsonProperty("agoalincome_a")
    private Double revenueA;

    @JsonProperty("agoalincome_b")
    private Double revenueB;

    @JsonProperty("agoalincome_absdelta")
    private Double revenueAbsDelta;

    @JsonProperty("agoalincome_delta")
    private Double revenuePctDelta;

    @JsonProperty("av_sum")
    private Double avgCpc;

    @JsonProperty("av_sum_a")
    private Double avgCpcA;

    @JsonProperty("av_sum_b")
    private Double avgCpcB;

    @JsonProperty("av_sum_absdelta")
    private Double avgCpcAbsDelta;

    @JsonProperty("av_sum_delta")
    private Double avgCpcPctDelta;

    @JsonProperty("sum")
    private Double cost;

    @JsonProperty("sum_a")
    private Double costA;

    @JsonProperty("sum_b")
    private Double costB;

    @JsonProperty("sum_absdelta")
    private Double costAbsDelta;

    @JsonProperty("sum_delta")
    private Double costPctDelta;

    @JsonProperty("avg_cpm")
    private Double avgCpm;

    @JsonProperty("avg_cpm_absdelta")
    private Double avgCpmAbsDelta;

    @JsonProperty("avg_cpm_delta")
    private Double avgCpmPctDelta;

    @JsonProperty("avg_cpm_a")
    private Double avgCpmA;

    @JsonProperty("avg_cpm_b")
    private Double avgCpmB;

    @JsonProperty("video_true_view")
    private Long videoTrueView;

    @JsonProperty("video_true_view_delta")
    private Double videoTrueViewPctDelta;

    @JsonProperty("video_true_view_absdelta")
    private Long videoTrueViewAbsDelta;

    @JsonProperty("video_true_view_a")
    private Long videoTrueViewA;

    @JsonProperty("video_true_view_b")
    private Long videoTrueViewB;

    @JsonProperty("avg_view_freq")
    private Double avgViewFreq;

    @JsonProperty("avg_view_freq_a")
    private Double avgViewFreqA;

    @JsonProperty("avg_view_freq_b")
    private Double avgViewFreqB;

    @JsonProperty("avg_view_freq_delta")
    private Double avgViewFreqPctDelta;

    @JsonProperty("avg_view_freq_absdelta")
    private Long avgViewFreqDelta;

    @JsonProperty("uniq_viewers")
    private Long uniqViewers;

    @JsonProperty("uniq_viewers_delta")
    private Double uniqViewersPctDelta;

    @JsonProperty("uniq_viewers_absdelta")
    private Long uniqViewersAbsDelta;

    @JsonProperty("uniq_viewers_a")
    private Long uniqViewersA;

    @JsonProperty("uniq_viewers_b")
    private Long uniqViewersB;

    @JsonProperty("ctr")
    private Double ctr;

    @JsonProperty("ctr_delta")
    private Double ctrPctDelta;

    @JsonProperty("ctr_absdelta")
    private Double ctrAbsDelta;

    @JsonProperty("ctr_a")
    private Double ctrA;

    @JsonProperty("ctr_b")
    private Double ctrB;

    @JsonProperty("avg_nshow")
    private Double avgNShow;

    @JsonProperty("avg_nshow_delta")
    private Double avgNShowDelta;

    @JsonProperty("avg_nshow_absdelta")
    private Double avgNShowAbsDelta;

    @JsonProperty("avg_nshow_a")
    private Double avgNShowA;

    @JsonProperty("avg_nshow_b")
    private Double avgNShowB;

    @JsonProperty("avg_nshow_complete")
    private Double avgNShowComplete;

    @JsonProperty("avg_nshow_complete_delta")
    private Double avgNShowCompleteDelta;

    @JsonProperty("avg_nshow_complete_absdelta")
    private Double avgNShowCompleteAbsDelta;

    @JsonProperty("avg_nshow_complete_a")
    private Double avgNShowCompleteA;

    @JsonProperty("avg_nshow_complete_b")
    private Double avgNShowCompleteB;

    @JsonProperty("video_avg_true_view_cost")
    private Double videoAvgTrueViewCost;

    @JsonProperty("video_avg_true_view_cost_delta")
    private Double videoAvgTrueViewCostPctDelta;

    @JsonProperty("video_avg_true_view_cost_absdelta")
    private Double videoAvgTrueViewCostAbsDelta;

    @JsonProperty("video_avg_true_view_cost_a")
    private Double videoAvgTrueViewCostA;

    @JsonProperty("video_avg_true_view_cost_b")
    private Double videoAvgTrueViewCostB;

    @JsonProperty("video_first_quartile_rate")
    private Double videoFirstQuartileRate;

    @JsonProperty("video_first_quartile_rate_delta")
    private Double videoFirstQuartileRatePctDelta;

    @JsonProperty("video_first_quartile_rate_absdelta")
    private Double videoFirstQuartileRateAbsDelta;

    @JsonProperty("video_first_quartile_rate_a")
    private Double videoFirstQuartileRateA;

    @JsonProperty("video_first_quartile_rate_b")
    private Double videoFirstQuartileRateB;

    @JsonProperty("video_midpoint_rate")
    private Double videoMidpointRate;

    @JsonProperty("video_midpoint_rate_delta")
    private Double videoMidpointRatePctDelta;

    @JsonProperty("video_midpoint_rate_absdelta")
    private Double videoMidpointRateAbsDelta;

    @JsonProperty("video_midpoint_rate_a")
    private Double videoMidpointRateA;

    @JsonProperty("video_midpoint_rate_b")
    private Double videoMidpointRateB;

    @JsonProperty("video_third_quartile_rate")
    private Double videoThirdQuartileRate;

    @JsonProperty("video_third_quartile_rate_delta")
    private Double videoThirdQuartileRatePctDelta;

    @JsonProperty("video_third_quartile_rate_absdelta")
    private Double videoThirdQuartileRateAbsDelta;

    @JsonProperty("video_third_quartile_rate_a")
    private Double videoThirdQuartileRateA;

    @JsonProperty("video_third_quartile_rate_b")
    private Double videoThirdQuartileRateB;

    @JsonProperty("video_complete_rate")
    private Double videoCompleteRate;

    @JsonProperty("video_complete_rate_delta")
    private Double videoCompleteRatePctDelta;

    @JsonProperty("video_complete_rate_absdelta")
    private Double videoCompleteRateAbsDelta;

    @JsonProperty("video_complete_rate_a")
    private Double videoCompleteRateA;

    @JsonProperty("video_complete_rate_b")
    private Double videoCompleteRateB;

    @JsonProperty("targeting_category")
    private String targetingCategory;

    @JsonProperty("contextcond_orig")
    private String contextCond;

    @JsonProperty("phrase")
    private String contextCondAsPhrase;

    public Double getCtr() {
        return ctr;
    }

    public CampaignStatisticsItem withCtr(Double ctr) {
        this.ctr = ctr;
        return this;
    }

    public Double getCtrPctDelta() {
        return ctrPctDelta;
    }

    public CampaignStatisticsItem withCtrPctDelta(Double ctrPctDelta) {
        this.ctrPctDelta = ctrPctDelta;
        return this;
    }

    public Double getCtrAbsDelta() {
        return ctrAbsDelta;
    }

    public CampaignStatisticsItem withCtrAbsDelta(Double ctrAbsDelta) {
        this.ctrAbsDelta = ctrAbsDelta;
        return this;
    }

    public Double getCtrA() {
        return ctrA;
    }

    public CampaignStatisticsItem withCtrA(Double ctrA) {
        this.ctrA = ctrA;
        return this;
    }

    public Double getCtrB() {
        return ctrB;
    }

    public CampaignStatisticsItem withCtrB(Double ctrB) {
        this.ctrB = ctrB;
        return this;
    }

    public Double getVideoAvgTrueViewCost() {
        return videoAvgTrueViewCost;
    }

    public CampaignStatisticsItem withVideoAvgTrueViewCost(Double videoAvgTrueViewCost) {
        this.videoAvgTrueViewCost = videoAvgTrueViewCost;
        return this;
    }

    public Double getVideoAvgTrueViewCostPctDelta() {
        return videoAvgTrueViewCostPctDelta;
    }

    public CampaignStatisticsItem withVideoAvgTrueViewCostPctDelta(Double videoAvgTrueViewCostPctDelta) {
        this.videoAvgTrueViewCostPctDelta = videoAvgTrueViewCostPctDelta;
        return this;
    }

    public Double getVideoAvgTrueViewCostAbsDelta() {
        return videoAvgTrueViewCostAbsDelta;
    }

    public CampaignStatisticsItem withVideoAvgTrueViewCostAbsDelta(Double videoAvgTrueViewCostAbsDelta) {
        this.videoAvgTrueViewCostAbsDelta = videoAvgTrueViewCostAbsDelta;
        return this;
    }

    public Double getVideoAvgTrueViewCostA() {
        return videoAvgTrueViewCostA;
    }

    public CampaignStatisticsItem withVideoAvgTrueViewCostA(Double videoAvgTrueViewCostA) {
        this.videoAvgTrueViewCostA = videoAvgTrueViewCostA;
        return this;
    }

    public Double getVideoAvgTrueViewCostB() {
        return videoAvgTrueViewCostB;
    }

    public CampaignStatisticsItem withVideoAvgTrueViewCostB(Double videoAvgTrueViewCostB) {
        this.videoAvgTrueViewCostB = videoAvgTrueViewCostB;
        return this;
    }

    public Double getVideoFirstQuartileRate() {
        return videoFirstQuartileRate;
    }

    public CampaignStatisticsItem withVideoFirstQuartileRate(Double videoFirstQuartileRate) {
        this.videoFirstQuartileRate = videoFirstQuartileRate;
        return this;
    }

    public Double getVideoFirstQuartileRatePctDelta() {
        return videoFirstQuartileRatePctDelta;
    }

    public CampaignStatisticsItem withVideoFirstQuartileRatePctDelta(Double videoFirstQuartileRatePctDelta) {
        this.videoFirstQuartileRatePctDelta = videoFirstQuartileRatePctDelta;
        return this;
    }

    public Double getVideoFirstQuartileRateAbsDelta() {
        return videoFirstQuartileRateAbsDelta;
    }

    public CampaignStatisticsItem withVideoFirstQuartileRateAbsDelta(Double videoFirstQuartileRateAbsDelta) {
        this.videoFirstQuartileRateAbsDelta = videoFirstQuartileRateAbsDelta;
        return this;
    }

    public Double getVideoFirstQuartileRateA() {
        return videoFirstQuartileRateA;
    }

    public CampaignStatisticsItem withVideoFirstQuartileRateA(Double videoFirstQuartileRateA) {
        this.videoFirstQuartileRateA = videoFirstQuartileRateA;
        return this;
    }

    public Double getVideoFirstQuartileRateB() {
        return videoFirstQuartileRateB;
    }

    public CampaignStatisticsItem withVideoFirstQuartileRateB(Double videoFirstQuartileRateB) {
        this.videoFirstQuartileRateB = videoFirstQuartileRateB;
        return this;
    }

    public Double getVideoMidpointRate() {
        return videoMidpointRate;
    }

    public CampaignStatisticsItem withVideoMidpointRate(Double videoMidpointRate) {
        this.videoMidpointRate = videoMidpointRate;
        return this;
    }

    public Double getVideoMidpointRatePctDelta() {
        return videoMidpointRatePctDelta;
    }

    public CampaignStatisticsItem withVideoMidpointRatePctDelta(Double videoMidpointRatePctDelta) {
        this.videoMidpointRatePctDelta = videoMidpointRatePctDelta;
        return this;
    }

    public Double getVideoMidpointRateAbsDelta() {
        return videoMidpointRateAbsDelta;
    }

    public CampaignStatisticsItem withVideoMidpointRateAbsDelta(Double videoMidpointRateAbsDelta) {
        this.videoMidpointRateAbsDelta = videoMidpointRateAbsDelta;
        return this;
    }

    public Double getVideoMidpointRateA() {
        return videoMidpointRateA;
    }

    public CampaignStatisticsItem withVideoMidpointRateA(Double videoMidpointRateA) {
        this.videoMidpointRateA = videoMidpointRateA;
        return this;
    }

    public Double getVideoMidpointRateB() {
        return videoMidpointRateB;
    }

    public CampaignStatisticsItem withVideoMidpointRateB(Double videoMidpointRateB) {
        this.videoMidpointRateB = videoMidpointRateB;
        return this;
    }

    public Double getVideoThirdQuartileRate() {
        return videoThirdQuartileRate;
    }

    public CampaignStatisticsItem withVideoThirdQuartileRate(Double videoThirdQuartileRate) {
        this.videoThirdQuartileRate = videoThirdQuartileRate;
        return this;
    }

    public Double getVideoThirdQuartileRatePctDelta() {
        return videoThirdQuartileRatePctDelta;
    }

    public CampaignStatisticsItem withVideoThirdQuartileRatePctDelta(Double videoThirdQuartileRatePctDelta) {
        this.videoThirdQuartileRatePctDelta = videoThirdQuartileRatePctDelta;
        return this;
    }

    public Double getVideoThirdQuartileRateAbsDelta() {
        return videoThirdQuartileRateAbsDelta;
    }

    public CampaignStatisticsItem withVideoThirdQuartileRateAbsDelta(Double videoThirdQuartileRateAbsDelta) {
        this.videoThirdQuartileRateAbsDelta = videoThirdQuartileRateAbsDelta;
        return this;
    }

    public Double getVideoThirdQuartileRateA() {
        return videoThirdQuartileRateA;
    }

    public CampaignStatisticsItem withVideoThirdQuartileRateA(Double videoThirdQuartileRateA) {
        this.videoThirdQuartileRateA = videoThirdQuartileRateA;
        return this;
    }

    public Double getVideoThirdQuartileRateB() {
        return videoThirdQuartileRateB;
    }

    public CampaignStatisticsItem withVideoThirdQuartileRateB(Double videoThirdQuartileRateB) {
        this.videoThirdQuartileRateB = videoThirdQuartileRateB;
        return this;
    }

    public Double getVideoCompleteRate() {
        return videoCompleteRate;
    }

    public CampaignStatisticsItem withVideoCompleteRate(Double videoCompleteRate) {
        this.videoCompleteRate = videoCompleteRate;
        return this;
    }

    public Double getVideoCompleteRatePctDelta() {
        return videoCompleteRatePctDelta;
    }

    public CampaignStatisticsItem withVideoCompleteRatePctDelta(Double videoCompleteRatePctDelta) {
        this.videoCompleteRatePctDelta = videoCompleteRatePctDelta;
        return this;
    }

    public Double getVideoCompleteRateAbsDelta() {
        return videoCompleteRateAbsDelta;
    }

    public CampaignStatisticsItem withVideoCompleteRateAbsDelta(Double videoCompleteRateAbsDelta) {
        this.videoCompleteRateAbsDelta = videoCompleteRateAbsDelta;
        return this;
    }

    public Double getVideoCompleteRateA() {
        return videoCompleteRateA;
    }

    public CampaignStatisticsItem withVideoCompleteRateA(Double videoCompleteRateA) {
        this.videoCompleteRateA = videoCompleteRateA;
        return this;
    }

    public Double getVideoCompleteRateB() {
        return videoCompleteRateB;
    }

    public CampaignStatisticsItem withVideoCompleteRateB(Double videoCompleteRateB) {
        this.videoCompleteRateB = videoCompleteRateB;
        return this;
    }

    public Double getAvgCpmAbsDelta() {
        return avgCpmAbsDelta;
    }

    public CampaignStatisticsItem withAvgCpmAbsDelta(Double avgCpmAbsDelta) {
        this.avgCpmAbsDelta = avgCpmAbsDelta;
        return this;
    }

    public Double getAvgCpmPctDelta() {
        return avgCpmPctDelta;
    }

    public CampaignStatisticsItem withAvgCpmPctDelta(Double avgCpmPctDelta) {
        this.avgCpmPctDelta = avgCpmPctDelta;
        return this;
    }

    public Double getVideoTrueViewPctDelta() {
        return videoTrueViewPctDelta;
    }

    public CampaignStatisticsItem withVideoTrueViewPctDelta(Double videoTrueViewPctDelta) {
        this.videoTrueViewPctDelta = videoTrueViewPctDelta;
        return this;
    }

    public Long getVideoTrueViewAbsDelta() {
        return videoTrueViewAbsDelta;
    }

    public CampaignStatisticsItem withVideoTrueViewAbsDelta(Long videoTrueViewAbsDelta) {
        this.videoTrueViewAbsDelta = videoTrueViewAbsDelta;
        return this;
    }

    public Long getUniqViewers() {
        return uniqViewers;
    }

    public CampaignStatisticsItem withUniqViewers(Long uniqViewers) {
        this.uniqViewers = uniqViewers;
        return this;
    }

    public Double getUniqViewersPctDelta() {
        return uniqViewersPctDelta;
    }

    public CampaignStatisticsItem withUniqViewersPctDelta(Double uniqViewersPctDelta) {
        this.uniqViewersPctDelta = uniqViewersPctDelta;
        return this;
    }

    public Long getUniqViewersAbsDelta() {
        return uniqViewersAbsDelta;
    }

    public CampaignStatisticsItem withUniqViewersAbsDelta(Long uniqViewersAbsDelta) {
        this.uniqViewersAbsDelta = uniqViewersAbsDelta;
        return this;
    }

    public Long getUniqViewersA() {
        return uniqViewersA;
    }

    public CampaignStatisticsItem withUniqViewersA(Long uniqViewersA) {
        this.uniqViewersA = uniqViewersA;
        return this;
    }

    public Long getUniqViewersB() {
        return uniqViewersB;
    }

    public CampaignStatisticsItem withUniqViewersB(Long uniqViewersB) {
        this.uniqViewersB = uniqViewersB;
        return this;
    }

    public Double getAvgCpmA() {
        return avgCpmA;
    }

    public CampaignStatisticsItem withAvgCpmA(Double avgCpmA) {
        this.avgCpmA = avgCpmA;
        return this;
    }

    public Double getAvgCpmB() {
        return avgCpmB;
    }

    public CampaignStatisticsItem withAvgCpmB(Double avgCpmB) {
        this.avgCpmB = avgCpmB;
        return this;
    }

    public Long getVideoTrueViewA() {
        return videoTrueViewA;
    }

    public CampaignStatisticsItem withVideoTrueViewA(Long videoTrueViewA) {
        this.videoTrueViewA = videoTrueViewA;
        return this;
    }

    public Long getVideoTrueViewB() {
        return videoTrueViewB;
    }

    public CampaignStatisticsItem setVideoTrueViewB(Long videoTrueViewB) {
        this.videoTrueViewB = videoTrueViewB;
        return this;
    }

    public Double getAvgViewFreqA() {
        return avgViewFreqA;
    }

    public Double getAvgViewFreqB() {
        return avgViewFreqB;
    }

    public CampaignStatisticsItem setAvgViewFreqA(Double avgViewFreqA) {
        this.avgViewFreqA = avgViewFreqA;
        return this;
    }

    public Double getAvgCpm() {
        return avgCpm;
    }

    public CampaignStatisticsItem withAvgCpm(Double avgCpm) {
        this.avgCpm = avgCpm;
        return this;
    }

    public Long getVideoTrueView() {
        return videoTrueView;
    }

    public CampaignStatisticsItem withVideoTrueView(Long videoTrueView) {
        this.videoTrueView = videoTrueView;
        return this;
    }

    public Double getAvgViewFreq() {
        return avgViewFreq;
    }

    public CampaignStatisticsItem withAvgViewFreq(Double avgViewFreq) {
        this.avgViewFreq = avgViewFreq;
        return this;
    }

    public CampaignStatisticsItem withAvgViewFreqB(Double avgViewFreqB) {
        this.avgViewFreqB = avgViewFreqB;
        return this;
    }

    public Double getAvgViewFreqPctDelta() {
        return avgViewFreqPctDelta;
    }

    public CampaignStatisticsItem setAvgViewFreqPctDelta(Double avgViewFreqPctDelta) {
        this.avgViewFreqPctDelta = avgViewFreqPctDelta;
        return this;
    }

    public Long getAvgViewFreqAbsDelta() {
        return avgViewFreqDelta;
    }

    public CampaignStatisticsItem setAvgViewFreqDelta(Long avgViewFreqDelta) {
        this.avgViewFreqDelta = avgViewFreqDelta;
        return this;
    }

    public LocalDate getDate() {
        return date;
    }

    public CampaignStatisticsItem withDate(LocalDate date) {
        this.date = date;
        return this;
    }

    public LocalDate getEndDate() {
        return endDate;
    }

    public CampaignStatisticsItem withEndDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    public CampaignStatisticsGenderType getGenderType() {
        return genderType;
    }

    public CampaignStatisticsItem withGenderType(CampaignStatisticsGenderType genderType) {
        this.genderType = genderType;
        return this;
    }

    public CampaignStatisticsAgeType getAgeType() {
        return ageType;
    }

    public CampaignStatisticsItem withAgeType(CampaignStatisticsAgeType ageType) {
        this.ageType = ageType;
        return this;
    }

    public Integer getRegion() {
        return region;
    }

    public CampaignStatisticsItem withRegion(Integer region) {
        this.region = region;
        return this;
    }

    public CampaignStatisticsDeviceType getDeviceType() {
        return deviceType;
    }

    public CampaignStatisticsItem withDeviceType(CampaignStatisticsDeviceType deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public Long getBid() {
        return bid;
    }

    public CampaignStatisticsItem withBid(Long bid) {
        this.bid = bid;
        return this;
    }

    public String getSearchQuery() {
        return searchQuery;
    }

    public CampaignStatisticsItem withSearchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
        return this;
    }

    public Long getShows() {
        return shows;
    }

    public CampaignStatisticsItem withShows(Long shows) {
        this.shows = shows;
        return this;
    }

    public Long getShowsA() {
        return showsA;
    }

    public CampaignStatisticsItem withShowsA(Long showsA) {
        this.showsA = showsA;
        return this;
    }

    public Long getShowsB() {
        return showsB;
    }

    public CampaignStatisticsItem withShowsB(Long showsB) {
        this.showsB = showsB;
        return this;
    }

    public Long getShowsAbsDelta() {
        return showsAbsDelta;
    }

    public CampaignStatisticsItem withShowsAbsDelta(Long showsAbsDelta) {
        this.showsAbsDelta = showsAbsDelta;
        return this;
    }

    public Double getShowsPctDelta() {
        return showsPctDelta;
    }

    public CampaignStatisticsItem withShowsPctDelta(Double showsPctDelta) {
        this.showsPctDelta = showsPctDelta;
        return this;
    }

    public Long getClicks() {
        return clicks;
    }

    public CampaignStatisticsItem withClicks(Long clicks) {
        this.clicks = clicks;
        return this;
    }

    public Long getClicksA() {
        return clicksA;
    }

    public CampaignStatisticsItem withClicksA(Long clicksA) {
        this.clicksA = clicksA;
        return this;
    }

    public Long getClicksB() {
        return clicksB;
    }

    public CampaignStatisticsItem withClicksB(Long clicksB) {
        this.clicksB = clicksB;
        return this;
    }

    public Long getClicksAbsDelta() {
        return clicksAbsDelta;
    }

    public CampaignStatisticsItem withClicksAbsDelta(Long clicksAbsDelta) {
        this.clicksAbsDelta = clicksAbsDelta;
        return this;
    }

    public Double getClicksPctDelta() {
        return clicksPctDelta;
    }

    public CampaignStatisticsItem withClicksPctDelta(Double clicksPctDelta) {
        this.clicksPctDelta = clicksPctDelta;
        return this;
    }

    public Long getConversions() {
        return conversions;
    }

    public CampaignStatisticsItem withConversions(Long conversions) {
        this.conversions = conversions;
        return this;
    }

    public Long getConversionsA() {
        return conversionsA;
    }

    public CampaignStatisticsItem withConversionsA(Long conversionsA) {
        this.conversionsA = conversionsA;
        return this;
    }

    public Long getConversionsB() {
        return conversionsB;
    }

    public CampaignStatisticsItem withConversionsB(Long conversionsB) {
        this.conversionsB = conversionsB;
        return this;
    }

    public Long getConversionsAbsDelta() {
        return conversionsAbsDelta;
    }

    public CampaignStatisticsItem withConversionsAbsDelta(Long conversionsAbsDelta) {
        this.conversionsAbsDelta = conversionsAbsDelta;
        return this;
    }

    public Double getConversionsPctDelta() {
        return conversionsPctDelta;
    }

    public CampaignStatisticsItem withConversionsPctDelta(Double conversionsPctDelta) {
        this.conversionsPctDelta = conversionsPctDelta;
        return this;
    }

    public Double getCostPerConversion() {
        return costPerConversion;
    }

    public CampaignStatisticsItem withCostPerConversion(Double costPerConversion) {
        this.costPerConversion = costPerConversion;
        return this;
    }

    public Double getCostPerConversionA() {
        return costPerConversionA;
    }

    public CampaignStatisticsItem withCostPerConversionA(Double costPerConversionA) {
        this.costPerConversionA = costPerConversionA;
        return this;
    }

    public Double getCostPerConversionB() {
        return costPerConversionB;
    }

    public CampaignStatisticsItem withCostPerConversionB(Double costPerConversionB) {
        this.costPerConversionB = costPerConversionB;
        return this;
    }

    public Double getCostPerConversionAbsDelta() {
        return costPerConversionAbsDelta;
    }

    public CampaignStatisticsItem withCostPerConversionAbsDelta(Double costPerConversionAbsDelta) {
        this.costPerConversionAbsDelta = costPerConversionAbsDelta;
        return this;
    }

    public Double getCostPerConversionPctDelta() {
        return costPerConversionPctDelta;
    }

    public CampaignStatisticsItem withCostPerConversionPctDelta(Double costPerConversionPctDelta) {
        this.costPerConversionPctDelta = costPerConversionPctDelta;
        return this;
    }

    public Double getRevenue() {
        return revenue;
    }

    public CampaignStatisticsItem withRevenue(Double revenue) {
        this.revenue = revenue;
        return this;
    }

    public Double getRevenueA() {
        return revenueA;
    }

    public CampaignStatisticsItem withRevenueA(Double revenueA) {
        this.revenueA = revenueA;
        return this;
    }

    public Double getRevenueB() {
        return revenueB;
    }

    public CampaignStatisticsItem withRevenueB(Double revenueB) {
        this.revenueB = revenueB;
        return this;
    }

    public Double getRevenueAbsDelta() {
        return revenueAbsDelta;
    }

    public CampaignStatisticsItem withRevenueAbsDelta(Double revenueAbsDelta) {
        this.revenueAbsDelta = revenueAbsDelta;
        return this;
    }

    public Double getRevenuePctDelta() {
        return revenuePctDelta;
    }

    public CampaignStatisticsItem withRevenuePctDelta(Double revenuePctDelta) {
        this.revenuePctDelta = revenuePctDelta;
        return this;
    }

    public Double getAvgCpc() {
        return avgCpc;
    }

    public CampaignStatisticsItem withAvgCpc(Double avgCpc) {
        this.avgCpc = avgCpc;
        return this;
    }

    public Double getAvgCpcA() {
        return avgCpcA;
    }

    public CampaignStatisticsItem withAvgCpcA(Double avgCpcA) {
        this.avgCpcA = avgCpcA;
        return this;
    }

    public Double getAvgCpcB() {
        return avgCpcB;
    }

    public CampaignStatisticsItem withAvgCpcB(Double avgCpcB) {
        this.avgCpcB = avgCpcB;
        return this;
    }

    public Double getAvgCpcAbsDelta() {
        return avgCpcAbsDelta;
    }

    public CampaignStatisticsItem withAvgCpcAbsDelta(Double avgCpcAbsDelta) {
        this.avgCpcAbsDelta = avgCpcAbsDelta;
        return this;
    }

    public Double getAvgCpcPctDelta() {
        return avgCpcPctDelta;
    }

    public CampaignStatisticsItem withAvgCpcPctDelta(Double avgCpcPctDelta) {
        this.avgCpcPctDelta = avgCpcPctDelta;
        return this;
    }

    public Double getCost() {
        return cost;
    }

    public CampaignStatisticsItem withCost(Double cost) {
        this.cost = cost;
        return this;
    }

    public Double getCostA() {
        return costA;
    }

    public CampaignStatisticsItem withCostA(Double costA) {
        this.costA = costA;
        return this;
    }

    public Double getCostB() {
        return costB;
    }

    public CampaignStatisticsItem withCostB(Double costB) {
        this.costB = costB;
        return this;
    }

    public Double getCostAbsDelta() {
        return costAbsDelta;
    }

    public CampaignStatisticsItem withCostAbsDelta(Double costAbsDelta) {
        this.costAbsDelta = costAbsDelta;
        return this;
    }

    public Double getCostPctDelta() {
        return costPctDelta;
    }

    public CampaignStatisticsItem withCostPctDelta(Double costPctDelta) {
        this.costPctDelta = costPctDelta;
        return this;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public void setGenderType(CampaignStatisticsGenderType genderType) {
        this.genderType = genderType;
    }

    public void setAgeType(CampaignStatisticsAgeType ageType) {
        this.ageType = ageType;
    }

    public void setRegion(Integer region) {
        this.region = region;
    }

    public void setDeviceType(CampaignStatisticsDeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public void setBid(Long bid) {
        this.bid = bid;
    }

    public void setSearchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
    }

    public void setShows(Long shows) {
        this.shows = shows;
    }

    public void setShowsA(Long showsA) {
        this.showsA = showsA;
    }

    public void setShowsB(Long showsB) {
        this.showsB = showsB;
    }

    public void setShowsAbsDelta(Long showsAbsDelta) {
        this.showsAbsDelta = showsAbsDelta;
    }

    public void setShowsPctDelta(Double showsPctDelta) {
        this.showsPctDelta = showsPctDelta;
    }

    public void setClicks(Long clicks) {
        this.clicks = clicks;
    }

    public void setClicksA(Long clicksA) {
        this.clicksA = clicksA;
    }

    public void setClicksB(Long clicksB) {
        this.clicksB = clicksB;
    }

    public void setClicksAbsDelta(Long clicksAbsDelta) {
        this.clicksAbsDelta = clicksAbsDelta;
    }

    public void setClicksPctDelta(Double clicksPctDelta) {
        this.clicksPctDelta = clicksPctDelta;
    }

    public void setConversions(Long conversions) {
        this.conversions = conversions;
    }

    public void setConversionsA(Long conversionsA) {
        this.conversionsA = conversionsA;
    }

    public void setConversionsB(Long conversionsB) {
        this.conversionsB = conversionsB;
    }

    public void setConversionsAbsDelta(Long conversionsAbsDelta) {
        this.conversionsAbsDelta = conversionsAbsDelta;
    }

    public void setConversionsPctDelta(Double conversionsPctDelta) {
        this.conversionsPctDelta = conversionsPctDelta;
    }

    public void setCostPerConversion(Double costPerConversion) {
        this.costPerConversion = costPerConversion;
    }

    public void setCostPerConversionA(Double costPerConversionA) {
        this.costPerConversionA = costPerConversionA;
    }

    public void setCostPerConversionB(Double costPerConversionB) {
        this.costPerConversionB = costPerConversionB;
    }

    public void setCostPerConversionAbsDelta(Double costPerConversionAbsDelta) {
        this.costPerConversionAbsDelta = costPerConversionAbsDelta;
    }

    public void setCostPerConversionPctDelta(Double costPerConversionPctDelta) {
        this.costPerConversionPctDelta = costPerConversionPctDelta;
    }

    public void setRevenue(Double revenue) {
        this.revenue = revenue;
    }

    public void setRevenueA(Double revenueA) {
        this.revenueA = revenueA;
    }

    public void setRevenueB(Double revenueB) {
        this.revenueB = revenueB;
    }

    public void setRevenueAbsDelta(Double revenueAbsDelta) {
        this.revenueAbsDelta = revenueAbsDelta;
    }

    public void setRevenuePctDelta(Double revenuePctDelta) {
        this.revenuePctDelta = revenuePctDelta;
    }

    public void setAvgCpc(Double avgCpc) {
        this.avgCpc = avgCpc;
    }

    public void setAvgCpcA(Double avgCpcA) {
        this.avgCpcA = avgCpcA;
    }

    public void setAvgCpcB(Double avgCpcB) {
        this.avgCpcB = avgCpcB;
    }

    public void setAvgCpcAbsDelta(Double avgCpcAbsDelta) {
        this.avgCpcAbsDelta = avgCpcAbsDelta;
    }

    public void setAvgCpcPctDelta(Double avgCpcPctDelta) {
        this.avgCpcPctDelta = avgCpcPctDelta;
    }

    public void setCost(Double cost) {
        this.cost = cost;
    }

    public void setCostA(Double costA) {
        this.costA = costA;
    }

    public void setCostB(Double costB) {
        this.costB = costB;
    }

    public void setCostAbsDelta(Double costAbsDelta) {
        this.costAbsDelta = costAbsDelta;
    }

    public void setCostPctDelta(Double costPctDelta) {
        this.costPctDelta = costPctDelta;
    }

    public void setAvgCpm(Double avgCpm) {
        this.avgCpm = avgCpm;
    }

    public void setAvgCpmA(Double avgCpmA) {
        this.avgCpmA = avgCpmA;
    }

    public void setAvgCpmB(Double avgCpmB) {
        this.avgCpmB = avgCpmB;
    }

    public void setAvgCpmAbsDelta(Double avgCpmAbsDelta) {
        this.avgCpmAbsDelta = avgCpmAbsDelta;
    }

    public void setAvgCpmPctDelta(Double avgCpmPctDelta) {
        this.avgCpmPctDelta = avgCpmPctDelta;
    }

    public void setCtr(Double ctr) {
        this.ctr = ctr;
    }

    public void setCtrA(Double ctrA) {
        this.ctrA = ctrA;
    }

    public void setCtrB(Double ctrB) {
        this.ctrB = ctrB;
    }

    public void setCtrAbsDelta(Double ctrAbsDelta) {
        this.ctrAbsDelta = ctrAbsDelta;
    }

    public void setCtrPctDelta(Double ctrPctDelta) {
        this.ctrPctDelta = ctrPctDelta;
    }

    public Long getCreativeId() {
        return creativeId;
    }

    public void setCreativeId(Long creativeId) {
        this.creativeId = creativeId;
    }

    public CampaignStatisticsItem withCreativeId(Long creativeId) {
        this.creativeId = creativeId;
        return this;
    }

    public Double getAvgNShow() {
        return avgNShow;
    }

    public void setAvgNShow(Double avgNShow) {
        this.avgNShow = avgNShow;
    }

    public Double getAvgNShowDelta() {
        return avgNShowDelta;
    }

    public void setAvgNShowDelta(Double avgNShowDelta) {
        this.avgNShowDelta = avgNShowDelta;
    }

    public Double getAvgNShowAbsDelta() {
        return avgNShowAbsDelta;
    }

    public void setAvgNShowAbsDelta(Double avgNShowAbsDelta) {
        this.avgNShowAbsDelta = avgNShowAbsDelta;
    }

    public Double getAvgNShowA() {
        return avgNShowA;
    }

    public void setAvgNShowA(Double avgNShowA) {
        this.avgNShowA = avgNShowA;
    }

    public Double getAvgNShowB() {
        return avgNShowB;
    }

    public void setAvgNShowB(Double avgNShowB) {
        this.avgNShowB = avgNShowB;
    }

    public Double getAvgNShowComplete() {
        return avgNShowComplete;
    }

    public void setAvgNShowComplete(Double avgNShowComplete) {
        this.avgNShowComplete = avgNShowComplete;
    }

    public Double getAvgNShowCompleteDelta() {
        return avgNShowCompleteDelta;
    }

    public void setAvgNShowCompleteDelta(Double avgNShowCompleteDelta) {
        this.avgNShowCompleteDelta = avgNShowCompleteDelta;
    }

    public Double getAvgNShowCompleteAbsDelta() {
        return avgNShowCompleteAbsDelta;
    }

    public void setAvgNShowCompleteAbsDelta(Double avgNShowCompleteAbsDelta) {
        this.avgNShowCompleteAbsDelta = avgNShowCompleteAbsDelta;
    }

    public Double getAvgNShowCompleteA() {
        return avgNShowCompleteA;
    }

    public void setAvgNShowCompleteA(Double avgNShowCompleteA) {
        this.avgNShowCompleteA = avgNShowCompleteA;
    }

    public Double getAvgNShowCompleteB() {
        return avgNShowCompleteB;
    }

    public void setAvgNShowCompleteB(Double avgNShowCompleteB) {
        this.avgNShowCompleteB = avgNShowCompleteB;
    }

    public void setTargetingCategory(String value) {
        targetingCategory = value;
    }
    public CampaignStatisticsItem withTargetingCategory(String value) {
        setTargetingCategory(value);
        return this;
    }

    public String getTargetingCategory() {
        return targetingCategory;
    }

    public void setContextCond(String value) {
        contextCond = value;
    }

    public CampaignStatisticsItem withContextCond(String value) {
        setContextCond(value);
        return this;
    }

    public String getContextCond() {
        return contextCond;
    }

    public void setContextCondAsPhrase(String value) {
        contextCondAsPhrase = value;
    }

    public CampaignStatisticsItem withContextCondAsPhrase(String value) {
        setContextCondAsPhrase(value);
        return this;
    }

    public String getContextCondAsPhrase() {
        return contextCondAsPhrase;
    }

    @Override
    public String toString() {
        return "CampaignStatisticsItem{" +
                "date=" + date +
                ", endDate=" + endDate +
                ", genderType=" + genderType +
                ", ageType=" + ageType +
                ", region=" + region +
                ", deviceType=" + deviceType +
                ", bid=" + bid +
                ", creativeId=" + creativeId +
                ", searchQuery='" + searchQuery + '\'' +
                ", shows=" + shows +
                ", showsA=" + showsA +
                ", showsB=" + showsB +
                ", showsAbsDelta=" + showsAbsDelta +
                ", showsPctDelta=" + showsPctDelta +
                ", clicks=" + clicks +
                ", clicksA=" + clicksA +
                ", clicksB=" + clicksB +
                ", clicksAbsDelta=" + clicksAbsDelta +
                ", clicksPctDelta=" + clicksPctDelta +
                ", conversions=" + conversions +
                ", conversionsA=" + conversionsA +
                ", conversionsB=" + conversionsB +
                ", conversionsAbsDelta=" + conversionsAbsDelta +
                ", conversionsPctDelta=" + conversionsPctDelta +
                ", costPerConversion=" + costPerConversion +
                ", costPerConversionA=" + costPerConversionA +
                ", costPerConversionB=" + costPerConversionB +
                ", costPerConversionAbsDelta=" + costPerConversionAbsDelta +
                ", costPerConversionPctDelta=" + costPerConversionPctDelta +
                ", revenue=" + revenue +
                ", revenueA=" + revenueA +
                ", revenueB=" + revenueB +
                ", revenueAbsDelta=" + revenueAbsDelta +
                ", revenuePctDelta=" + revenuePctDelta +
                ", avgCpc=" + avgCpc +
                ", avgCpcA=" + avgCpcA +
                ", avgCpcB=" + avgCpcB +
                ", avgCpcAbsDelta=" + avgCpcAbsDelta +
                ", avgCpcPctDelta=" + avgCpcPctDelta +
                ", cost=" + cost +
                ", costA=" + costA +
                ", costB=" + costB +
                ", costAbsDelta=" + costAbsDelta +
                ", costPctDelta=" + costPctDelta +
                ", avgCpm=" + avgCpm +
                ", avgCpmAbsDelta=" + avgCpmAbsDelta +
                ", avgCpmPctDelta=" + avgCpmPctDelta +
                ", avgCpmA=" + avgCpmA +
                ", avgCpmB=" + avgCpmB +
                ", videoTrueView=" + videoTrueView +
                ", videoTrueViewPctDelta=" + videoTrueViewPctDelta +
                ", videoTrueViewAbsDelta=" + videoTrueViewAbsDelta +
                ", videoTrueViewA=" + videoTrueViewA +
                ", videoTrueViewB=" + videoTrueViewB +
                ", avgViewFreq=" + avgViewFreq +
                ", avgViewFreqA=" + avgViewFreqA +
                ", avgViewFreqB=" + avgViewFreqB +
                ", avgViewFreqPctDelta=" + avgViewFreqPctDelta +
                ", avgViewFreqDelta=" + avgViewFreqDelta +
                ", uniqViewers=" + uniqViewers +
                ", uniqViewersPctDelta=" + uniqViewersPctDelta +
                ", uniqViewersAbsDelta=" + uniqViewersAbsDelta +
                ", uniqViewersA=" + uniqViewersA +
                ", uniqViewersB=" + uniqViewersB +
                ", ctr=" + ctr +
                ", ctrPctDelta=" + ctrPctDelta +
                ", ctrAbsDelta=" + ctrAbsDelta +
                ", ctrA=" + ctrA +
                ", ctrB=" + ctrB +
                ", avgNShow=" + avgNShow +
                ", avgNShowDelta=" + avgNShowDelta +
                ", avgNShowAbsDelta=" + avgNShowAbsDelta +
                ", avgNShowA=" + avgNShowA +
                ", avgNShowB=" + avgNShowB +
                ", avgNShowComplete=" + avgNShowComplete +
                ", avgNShowCompleteDelta=" + avgNShowCompleteDelta +
                ", avgNShowCompleteAbsDelta=" + avgNShowCompleteAbsDelta +
                ", avgNShowCompleteA=" + avgNShowCompleteA +
                ", avgNShowCompleteB=" + avgNShowCompleteB +
                ", videoAvgTrueViewCost=" + videoAvgTrueViewCost +
                ", videoAvgTrueViewCostPctDelta=" + videoAvgTrueViewCostPctDelta +
                ", videoAvgTrueViewCostAbsDelta=" + videoAvgTrueViewCostAbsDelta +
                ", videoAvgTrueViewCostA=" + videoAvgTrueViewCostA +
                ", videoAvgTrueViewCostB=" + videoAvgTrueViewCostB +
                ", videoFirstQuartileRate=" + videoFirstQuartileRate +
                ", videoFirstQuartileRatePctDelta=" + videoFirstQuartileRatePctDelta +
                ", videoFirstQuartileRateAbsDelta=" + videoFirstQuartileRateAbsDelta +
                ", videoFirstQuartileRateA=" + videoFirstQuartileRateA +
                ", videoFirstQuartileRateB=" + videoFirstQuartileRateB +
                ", videoMidpointRate=" + videoMidpointRate +
                ", videoMidpointRatePctDelta=" + videoMidpointRatePctDelta +
                ", videoMidpointRateAbsDelta=" + videoMidpointRateAbsDelta +
                ", videoMidpointRateA=" + videoMidpointRateA +
                ", videoMidpointRateB=" + videoMidpointRateB +
                ", videoThirdQuartileRate=" + videoThirdQuartileRate +
                ", videoThirdQuartileRatePctDelta=" + videoThirdQuartileRatePctDelta +
                ", videoThirdQuartileRateAbsDelta=" + videoThirdQuartileRateAbsDelta +
                ", videoThirdQuartileRateA=" + videoThirdQuartileRateA +
                ", videoThirdQuartileRateB=" + videoThirdQuartileRateB +
                ", videoCompleteRate=" + videoCompleteRate +
                ", videoCompleteRatePctDelta=" + videoCompleteRatePctDelta +
                ", videoCompleteRateAbsDelta=" + videoCompleteRateAbsDelta +
                ", videoCompleteRateA=" + videoCompleteRateA +
                ", videoCompleteRateB=" + videoCompleteRateB +
                ", targetingCategory=" + targetingCategory +
                ", contextCond=" + contextCond +
                '}';
    }
}
