package ru.yandex.direct.intapi.client.model.response.statistics;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class CampaignStatisticsResponse {

    @JsonProperty("data_array")
    private List<CampaignStatisticsItem> data;

    @JsonProperty("totals")
    private CampaignStatisticsItem totals;

    @JsonProperty("error_code")
    private String errorCode;

    @JsonProperty("error")
    private String error;

    public List<CampaignStatisticsItem> getData() {
        return data;
    }

    public CampaignStatisticsItem getTotals() {
        return totals;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public String getError() {
        return error;
    }

    public void setData(List<CampaignStatisticsItem> data) {
        this.data = data;
    }

    public void setTotals(CampaignStatisticsItem totals) {
        this.totals = totals;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setError(String error) {
        this.error = error;
    }

    public CampaignStatisticsResponse withData(List<CampaignStatisticsItem> data) {
        this.data = data;
        return this;
    }

    public CampaignStatisticsResponse withTotals(CampaignStatisticsItem totals) {
        setTotals(totals);
        return this;
    }
}
