package ru.yandex.direct.intapi.client

import ru.yandex.direct.asynchttp.ParallelFetcherFactory
import ru.yandex.direct.feature.FeatureHistoryEvent
import ru.yandex.direct.http.smart.core.Call
import ru.yandex.direct.http.smart.core.Smart
import ru.yandex.direct.http.smart.error.ErrorUtils.checkResultForErrors
import ru.yandex.direct.tvm.TvmIntegration
import ru.yandex.direct.tvm.TvmService

class IntapiSmartClient(
    parallelFetcherFactory: ParallelFetcherFactory,
    tvmIntegration: TvmIntegration,
    tvmService: TvmService,
    baseUrl: String,
) {
    private val intapi = Smart.builder()
        .withParallelFetcherFactory(parallelFetcherFactory)
        .withProfileName("intapi_client")
        .withBaseUrl(baseUrl)
        .useTvm(tvmIntegration, tvmService)
        .build()
        .create(IntapiApi::class.java)

    fun getFeaturesHistory(afterEventId: Long): List<FeatureHistoryEvent> =
        intapi.featuresHistory(afterEventId).executeCall()

    private fun <T> Call<T>.executeCall(): T {
        val result = execute()
        checkResultForErrors(result, { RuntimeException(it) })
        return result.success
    }
}

