package ru.yandex.direct.display.landing.client.submissions;

import java.time.OffsetDateTime;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import static ru.yandex.direct.utils.JsonUtils.fromJson;

/**
 * Дата-класс, описывающий ответ клиента к Дисплею - Лендингам, список заявок или возникшая ошибка
 */
@JsonNaming(value = PropertyNamingStrategy.UpperCamelCaseStrategy.class)
public class GetSubmissionsResponse {

    /**
     * Дата-класс, описывающий заявку, отправленную с турбо-страницы
     */
    @JsonNaming(value = PropertyNamingStrategy.UpperCamelCaseStrategy.class)
    public static class Submission {
        private OffsetDateTime submittedAt;
        private Long turboPageId;
        private String turboPageName;
        private String id;
        private List<DataItem> data;

        public Submission() {
        }

        /**
         * @return дата и время, когда была отправлена заявка
         */
        public OffsetDateTime getSubmittedAt() {
            return submittedAt;
        }

        /**
         * @return идентификатор турбо-страницы
         */
        public Long getTurboPageId() {
            return turboPageId;
        }

        /**
         * @return имя турбо-страницы
         */
        public String getTurboPageName() {
            return turboPageName;
        }

        /**
         * @return идентификатор заявки
         */
        public String getId() {
            return id;
        }

        /**
         * @return данные, переданные пользователем в заявке
         */
        public List<DataItem> getData() {
            return data;
        }

        public void setSubmittedAt(String submittedAt) {
            this.submittedAt = OffsetDateTime.parse(submittedAt);
        }

        public void setTurboPageId(Long turboPageId) {
            this.turboPageId = turboPageId;
        }

        public void setTurboPageName(String turboPageName) {
            this.turboPageName = turboPageName;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setData(
                List<DataItem> data) {
            this.data = data;
        }
    }

    /**
     * Дата-класс, описывающий элемент данных, которые пользователь передал в заявке
     */
    @JsonNaming(value = PropertyNamingStrategy.UpperCamelCaseStrategy.class)
    public static class DataItem {
        private String fieldName;
        private String value;

        /**
         * @return название поля
         */
        public String getFieldName() {
            return fieldName;
        }

        /**
         * @return значение поля, введенное пользователем
         */
        public String getValue() {
            return value;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    private List<Submission> submissions;
    private int limitedBy;

    private int errorCode;
    private String errorDetail;

    /**
     * @return список заявок, возвращается, только если не было ошибки
     */
    public List<Submission> getSubmissions() {
        return submissions;
    }

    /**
     * номер следующей за последней выбранной заявкой, если она есть
     */
    public int getLimitedBy() {
        return limitedBy;
    }

    /**
     * @return код ошибки
     */
    public int getErrorCode() {
        return errorCode;
    }

    /**
     * @return описание ошибки
     */
    public String getErrorDetail() {
        return errorDetail;
    }


    public void setSubmissions(List<Submission> submissions) {
        this.submissions = submissions;
    }

    public void setLimitedBy(int limitedBy) {
        this.limitedBy = limitedBy;
    }

    @JsonProperty(value = "error_code")
    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    @JsonProperty(value = "error_detail")
    public void setErrorDetail(String errorDetail) {
        this.errorDetail = errorDetail;
    }


    public static GetSubmissionsResponse deserialize(String resp) {
        return fromJson(resp, GetSubmissionsResponse.class);
    }
}
