package ru.yandex.direct.dssclient;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Идентификация (и секретная строка для аутентификации) программы, которая ходит в DSS, например, для Директа
 * В тестинге работает cryptopro.cloud.csp с пустым секретом
 * <p>
 * Новых клиентов должны регистрировать администраторы DSS на их стороне
 */
@ParametersAreNonnullByDefault
public class DssClientCredentials {
    private final String clientId;
    private final String clientSecret;

    @JsonCreator
    public DssClientCredentials(@JsonProperty("client_id") String clientId,
                                @JsonProperty("client_secret") String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public String getClientId() {
        return clientId;
    }

    public String getClientSecret() {
        return clientSecret;
    }
}
