package ru.yandex.direct.dssclient;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Идентификация (и пароль для аутентификации) пользователя DSS, от имени которого
 * программа делает запросы, например, robot-direct-dsssign
 * <p>
 * Нового пользователя можно попробовать завести через веб-интерфейс: http://dss.yandex-team.ru/Frontend/;
 * но может статься, что его выключат, тогда надо обратиться за консультацией к администраторам DSS.
 */
@ParametersAreNonnullByDefault
public class DssUserCredentials {
    private final String username;
    private final String password;

    @JsonCreator
    public DssUserCredentials(@JsonProperty("username") String username,
                              @JsonProperty("password") String password) {
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return username;
    }

    public String getPassword() {
        return password;
    }

    @Override
    @SuppressWarnings("squid:S2068") // hardcoded '***' is not really a password
    public String toString() {
        return "DssUserCredentials{" +
                "username='" + username + '\'' +
                ", password='***'" +
                '}';
    }
}
