package ru.yandex.direct.dssclient.http;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class HttpConnectorSettings {
    private static final String DEFAULT_BASE_URL = "https://bosign-tst.ld.yandex.ru";
    private static final int DEFAULT_TIMEOUT = 40;

    private final String baseUrl;
    private final int timeoutInMs;

    public static final HttpConnectorSettings DEFAULT = new HttpConnectorSettings(DEFAULT_BASE_URL, DEFAULT_TIMEOUT);

    public HttpConnectorSettings(String baseUrl, int timeout) {
        this.baseUrl = baseUrl;
        this.timeoutInMs = timeout * 1000;
    }

    public String getBaseUrl() {
        return baseUrl;
    }

    public int getTimeoutInMs() {
        return timeoutInMs;
    }
}
