package ru.yandex.direct.dssclient.http.auth;

import java.util.Base64;

import ru.yandex.direct.dssclient.DssClientCredentials;

public class BasicAuth implements Auth {
    private final DssClientCredentials clientCredentials;

    public BasicAuth(DssClientCredentials clientCredentials) {
        this.clientCredentials = clientCredentials;
    }

    public String getAuthHeader() {
        String auth = clientCredentials.getClientId() + ":" + clientCredentials.getClientSecret();
        return "Basic " + Base64.getEncoder().encodeToString(auth.getBytes());
    }
}
