package ru.yandex.direct.dssclient.http.auth;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

import com.google.common.base.Suppliers;

import ru.yandex.direct.dssclient.DssClientCredentials;
import ru.yandex.direct.dssclient.DssUserCredentials;
import ru.yandex.direct.dssclient.http.HttpConnector;
import ru.yandex.direct.dssclient.http.HttpConnectorSettings;
import ru.yandex.direct.dssclient.http.responses.OauthTokenResponse;

public class OwnerAuth implements Auth {
    private final Supplier<String> accessTokenSupplier;

    public OwnerAuth(HttpConnectorSettings httpConnectorSettings, DssUserCredentials userCredentials,
                     DssClientCredentials clientCredentials) {
        accessTokenSupplier = Suppliers.memoizeWithExpiration(
                () -> getAccessToken(httpConnectorSettings, userCredentials, clientCredentials),
                30, TimeUnit.SECONDS);
    }

    private static String getAccessToken(HttpConnectorSettings httpConnectorSettings,
                                         DssUserCredentials userCredentials, DssClientCredentials clientCredentials) {
        HttpConnector httpConnector = new HttpConnector(new BasicAuth(clientCredentials), httpConnectorSettings);
        OauthTokenResponse oauthTokenResponse = httpConnector.getOauthToken(
                clientCredentials.getClientId(),
                userCredentials.getUsername(), userCredentials.getPassword());

        return oauthTokenResponse.getAccessToken();
    }

    @Override
    public String getAuthHeader() {
        return "Bearer " + accessTokenSupplier.get();
    }
}
