package ru.yandex.direct.dssclient.http.certificates;

import java.math.BigInteger;
import java.util.Date;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

public class Certificate {
    private final Long id;
    private final String pinCode;
    private final BigInteger certificateSerialNumber;
    private final boolean isActive;
    private final Date startDate;
    private final Date endDate;
    private final Map<SubjectField, String> subject;

    public Certificate(Long id, String pinCode,
                       BigInteger certificateSerialNumber, boolean isActive,
                       Date startDate, Date endDate,
                       Map<SubjectField, String> subject) {
        this.id = id;
        this.pinCode = pinCode;
        this.certificateSerialNumber = certificateSerialNumber;
        this.isActive = isActive;
        this.startDate = startDate;
        this.endDate = endDate;
        this.subject = ImmutableMap.copyOf(subject);
    }

    public Long getId() {
        return id;
    }

    public String getPinCode() {
        return pinCode;
    }

    public BigInteger getCertificateSerialNumber() {
        return certificateSerialNumber;
    }

    public boolean isActive() {
        return isActive;
    }

    public Date getStartDate() {
        return startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public Map<SubjectField, String> getSubject() {
        return subject;
    }

    @Override
    public String toString() {
        return "Certificate{" +
                "id=" + id +
                ", pinCode='" + pinCode + '\'' +
                ", certificateSerialNumber=" + certificateSerialNumber +
                ", isActive=" + isActive +
                ", startDate=" + startDate +
                ", endDate=" + endDate +
                ", subject=" + subject +
                '}';
    }
}
