package ru.yandex.direct.dssclient.http.certificates;

import java.util.Arrays;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static java.util.function.Function.identity;
import static java.util.stream.Collectors.toMap;

@SuppressWarnings("squid:S1313") // это не IP-адреса
public enum SubjectField {
    COMMON_NAME("2.5.4.3"),
    SURNAME("2.5.4.4"),
    COUNTRY("2.5.4.6"),
    SERIAL("2.5.4.5"),
    LOCALITY("2.5.4.7"),
    STATE_PROVINCE("2.5.4.8"),
    STREET("2.5.4.9"),
    ORGANIZATION("2.5.4.10"),
    ORGANIZATION_UNIT("2.5.4.11"),
    TITLE("2.5.4.12"),
    ZIP("2.5.4.17"),
    NAME("2.5.4.41"),
    GIVEN_NAME("2.5.4.42"),
    INITIALS("2.5.4.43"),
    PSEUDONYM("2.5.4.65"),
    EMAIL("1.2.840.113549.1.9.1"),
    UNSTRUCTURED_NAME("1.2.840.113549.1.9.2");

    private static final Logger LOGGER = LoggerFactory.getLogger(SubjectField.class);

    private final String code;

    SubjectField(String code) {
        this.code = code;
    }

    public String getCode() {
        return code;
    }

    private static final Map<String, SubjectField> BY_CODE = Arrays.stream(SubjectField.values())
            .collect(toMap(SubjectField::getCode, identity()));

    public static SubjectField valueOfCode(String code) {
        if (!BY_CODE.containsKey(code)) {
            LOGGER.warn("unknown code {}", code);
            return null;
        }

        return BY_CODE.get(code);
    }
}
