package ru.yandex.direct.dssclient.http.requests.signdocument;

public class Parameters {
    private PdfFormat pdfFormat;
    private String pdfSignatureAppearance;
    private int pdfSignatureTemplateId;

    public enum PdfFormat {
        CMS,
        CAdES;
    }

    public PdfFormat getPdfFormat() {
        return pdfFormat;
    }

    public void setPdfFormat(PdfFormat pdfFormat) {
        this.pdfFormat = pdfFormat;
    }

    public String getPdfSignatureAppearance() {
        return pdfSignatureAppearance;
    }

    public void setPdfSignatureAppearance(String pdfSignatureAppearance) {
        this.pdfSignatureAppearance = pdfSignatureAppearance;
    }

    public int getPdfSignatureTemplateId() {
        return pdfSignatureTemplateId;
    }

    public void setPdfSignatureTemplateId(int pdfSignatureTemplateId) {
        this.pdfSignatureTemplateId = pdfSignatureTemplateId;
    }

    public static class Builder {
        private PdfFormat pdfFormat;
        private String pdfSignatureAppearance;
        private int pdfSignatureTemplateId;

        public Builder withPdfFormat(PdfFormat pdfFormat) {
            this.pdfFormat = pdfFormat;
            return this;
        }

        public Builder withPdfSignatureAppearance(
                String pdfSignatureAppearance) {
            this.pdfSignatureAppearance = pdfSignatureAppearance;
            return this;
        }

        public Builder withPdfSignatureTemplateId(int pdfSignatureTemplateId) {
            this.pdfSignatureTemplateId = pdfSignatureTemplateId;
            return this;
        }

        public Parameters build() {
            Parameters result = new Parameters();
            result.setPdfFormat(pdfFormat);
            result.setPdfSignatureAppearance(pdfSignatureAppearance);
            result.setPdfSignatureTemplateId(pdfSignatureTemplateId);
            return result;
        }
    }
}
