package ru.yandex.direct.dssclient.http.requests.signdocument;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonNaming(PropertyNamingStrategy.UpperCamelCaseStrategy.class)
public class SignDocumentRequest {
    private String content;
    private String name;
    private Signature signature;

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Signature getSignature() {
        return signature;
    }

    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    public static class Builder {
        private String content;
        private String name;
        private Signature signature;

        public Builder withContent(String content) {
            this.content = content;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withSignature(Signature signature) {
            this.signature = signature;
            return this;
        }

        public SignDocumentRequest build() {
            SignDocumentRequest result = new SignDocumentRequest();
            result.setContent(content);
            result.setName(name);
            result.setSignature(signature);
            return result;
        }
    }
}
