package ru.yandex.direct.dssclient.http.requests.signdocument;

public class Signature {
    private Long certificateId;
    private Long type;
    private String pinCode;
    private Parameters parameters;

    public Long getCertificateId() {
        return certificateId;
    }

    public void setCertificateId(Long certificateId) {
        this.certificateId = certificateId;
    }

    public Long getType() {
        return type;
    }

    public void setType(Long type) {
        this.type = type;
    }

    public String getPinCode() {
        return pinCode;
    }

    public void setPinCode(String pinCode) {
        this.pinCode = pinCode;
    }

    public Parameters getParameters() {
        return parameters;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public static class Builder {
        private Long certificateId;
        private Long type;
        private String pinCode;
        private Parameters parameters;

        public Builder withCertificateId(Long certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public Builder withType(Long type) {
            this.type = type;
            return this;
        }

        public Builder withPinCode(String pinCode) {
            this.pinCode = pinCode;
            return this;
        }

        public Builder withParameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Signature build() {
            Signature result = new Signature();
            result.setCertificateId(certificateId);
            result.setType(type);
            result.setPinCode(pinCode);
            result.setParameters(parameters);
            return result;
        }
    }
}
