package ru.yandex.direct.dssclient.http.responses;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonNaming(PropertyNamingStrategy.UpperCamelCaseStrategy.class)
public class CertificateResponse {
    private String certificateType;
    private Long id;
    private String dName;
    private String certificateBase64;
    private Status status;
    private Boolean isDefault;
    private Long certificateAuthorityId;
    private String cspId;
    private List<String> hashAlgorithms;
    private String providerName;
    private Long providerType;
    private String privateKeyNotBefore;
    private String privateKeyNotAfter;
    private Boolean hasPin;
    private String friendlyName;

    @JsonNaming(PropertyNamingStrategy.UpperCamelCaseStrategy.class)
    public static class Status {
        private StatusValue value;
        private String revocationInfo;
        private String pinCode;
        private Long activeCertId;

        public enum StatusValue {
            ACTIVE,
            REVOKED,
            HOLD,
            NOT_VALID,
            OUT_OF_ORDER;
        }

        public StatusValue getValue() {
            return value;
        }

        public void setValue(StatusValue value) {
            this.value = value;
        }

        public String getRevocationInfo() {
            return revocationInfo;
        }

        public void setRevocationInfo(String revocationInfo) {
            this.revocationInfo = revocationInfo;
        }

        public String getPinCode() {
            return pinCode;
        }

        public void setPinCode(String pinCode) {
            this.pinCode = pinCode;
        }

        public Long getActiveCertId() {
            return activeCertId;
        }

        public void setActiveCertId(Long activeCertId) {
            this.activeCertId = activeCertId;
        }

        @Override
        public String toString() {
            return "Status{" +
                    "value=" + value +
                    ", revocationInfo='" + revocationInfo + '\'' +
                    ", pinCode='" + pinCode + '\'' +
                    ", activeCertId=" + activeCertId +
                    '}';
        }
    }

    public String getCertificateType() {
        return certificateType;
    }

    public void setCertificateType(String certificateType) {
        this.certificateType = certificateType;
    }

    public Long getId() {
        return id;
    }

    @JsonProperty("ID")
    public void setId(Long id) {
        this.id = id;
    }

    public String getdName() {
        return dName;
    }

    public void setdName(String dname) {
        this.dName = dname;
    }

    public String getCertificateBase64() {
        return certificateBase64;
    }

    public void setCertificateBase64(String certificateBase64) {
        this.certificateBase64 = certificateBase64;
    }

    public Status getStatus() {
        return status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Boolean getDefault() {
        return isDefault;
    }

    @JsonProperty("IsDefault")
    public void setDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public Long getCertificateAuthorityId() {
        return certificateAuthorityId;
    }

    @JsonProperty("CertificateAuthorityID")
    public void setCertificateAuthorityId(Long certificateAuthorityId) {
        this.certificateAuthorityId = certificateAuthorityId;
    }

    public String getCspId() {
        return cspId;
    }

    @JsonProperty("CspID")
    public void setCspId(String cspId) {
        this.cspId = cspId;
    }

    public List<String> getHashAlgorithms() {
        return hashAlgorithms;
    }

    public void setHashAlgorithms(List<String> hashAlgorithms) {
        this.hashAlgorithms = hashAlgorithms;
    }

    public String getProviderName() {
        return providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public Long getProviderType() {
        return providerType;
    }

    public void setProviderType(Long providerType) {
        this.providerType = providerType;
    }

    public String getPrivateKeyNotBefore() {
        return privateKeyNotBefore;
    }

    public void setPrivateKeyNotBefore(String privateKeyNotBefore) {
        this.privateKeyNotBefore = privateKeyNotBefore;
    }

    public String getPrivateKeyNotAfter() {
        return privateKeyNotAfter;
    }

    public void setPrivateKeyNotAfter(String privateKeyNotAfter) {
        this.privateKeyNotAfter = privateKeyNotAfter;
    }

    public Boolean getHasPin() {
        return hasPin;
    }

    public void setHasPin(Boolean hasPin) {
        this.hasPin = hasPin;
    }

    public String getFriendlyName() {
        return friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    @Override
    public String toString() {
        return "CertificateResponse{" +
                "certificateType='" + certificateType + '\'' +
                ", id=" + id +
                ", dName='" + dName + '\'' +
                ", certificateBase64='" + certificateBase64 + '\'' +
                ", status=" + status +
                ", isDefault=" + isDefault +
                ", certificateAuthorityId=" + certificateAuthorityId +
                ", cspId='" + cspId + '\'' +
                ", hashAlgorithms=" + hashAlgorithms +
                ", providerName='" + providerName + '\'' +
                ", providerType=" + providerType +
                ", privateKeyNotBefore='" + privateKeyNotBefore + '\'' +
                ", privateKeyNotAfter='" + privateKeyNotAfter + '\'' +
                ", hasPin=" + hasPin +
                ", friendlyName='" + friendlyName + '\'' +
                '}';
    }
}
