package ru.yandex.direct.dssclient.pdfstamp;

import com.google.common.collect.ImmutableMap;

public class Box {
    public static final Color DEFAULT_BACKGROUND_COLOR = Colors.WHITE;
    public static final int DEFAULT_MARGIN = 5;
    public static final int DEFAULT_WIDTH = 200;
    public static final int DEFAULT_HEIGHT = 80;
    public static final int DEFAULT_X_POSITION = 20;
    public static final int DEFAULT_Y_POSITION = 20;
    public static final Color DEFAULT_BORDER_COLOR = Colors.BLACK;
    public static final int DEFAULT_BORDER_RADIUS = 0;
    public static final int DEFAULT_BORDER_WIDTH = 1;

    public static final Box DEFAULT = new Builder()
            .setBackgroundColor(DEFAULT_BACKGROUND_COLOR)
            .setMargin(DEFAULT_MARGIN)
            .setWidth(DEFAULT_WIDTH)
            .setHeight(DEFAULT_HEIGHT)
            .setHorizontalPosition(DEFAULT_X_POSITION)
            .setVerticalPosition(DEFAULT_Y_POSITION)
            .setBorderColor(DEFAULT_BORDER_COLOR)
            .setBorderRadius(DEFAULT_BORDER_RADIUS)
            .setBorderWidth(DEFAULT_BORDER_WIDTH)
            .build();

    private final Color backgroundColor;
    private final int margin;
    private final int width;
    private final int height;
    private final int horizontalPosition;
    private final int verticalPosition;
    private final Color borderColor;
    private final int borderRadius;
    private final int borderWidth;

    private Box(Color backgroundColor, int margin, int width, int height, int horizontalPosition, int verticalPosition,
                Color borderColor, int borderRadius, int borderWidth) {
        this.backgroundColor = backgroundColor;
        this.margin = margin;
        this.width = width;
        this.height = height;
        this.horizontalPosition = horizontalPosition;
        this.verticalPosition = verticalPosition;
        this.borderColor = borderColor;
        this.borderRadius = borderRadius;
        this.borderWidth = borderWidth;
    }

    public Color getBackgroundColor() {
        return backgroundColor;
    }

    public int getMargin() {
        return margin;
    }

    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return height;
    }

    public int getHorizontalPosition() {
        return horizontalPosition;
    }

    public int getVerticalPosition() {
        return verticalPosition;
    }

    public Color getBorderColor() {
        return borderColor;
    }

    public int getBorderRadius() {
        return borderRadius;
    }

    public int getBorderWidth() {
        return borderWidth;
    }

    public Object toJsonObject() {
        ImmutableMap.Builder<String, Object> resultBuilder = ImmutableMap.<String, Object>builder()
                .put("LowerLeftX", horizontalPosition)
                .put("LowerLeftY", verticalPosition)
                .put("UpperRightX", horizontalPosition + width)
                .put("UpperRightY", verticalPosition + height)
                .put("ContentMargin", margin)
                .put("BorderRadius", borderRadius)
                .put("BorderWeight", borderWidth);

        if (borderColor != null) {
            resultBuilder.put("BorderColor", borderColor.toJsonObject());
        }

        if (backgroundColor != null) {
            resultBuilder.put("BackgroundColor", backgroundColor.toJsonObject());
        }

        return resultBuilder.build();
    }

    public static class Builder {
        private Color backgroundColor;
        private int margin;
        private int width;
        private int height;
        private int horizontalPosition;
        private int verticalPosition;
        private Color borderColor;
        private int borderRadius;
        private int borderWidth;

        public Builder setBackgroundColor(Color backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder setMargin(int margin) {
            this.margin = margin;
            return this;
        }

        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        public Builder setHorizontalPosition(int horizontalPosition) {
            this.horizontalPosition = horizontalPosition;
            return this;
        }

        public Builder setVerticalPosition(int verticalPosition) {
            this.verticalPosition = verticalPosition;
            return this;
        }

        public Builder setBorderColor(Color borderColor) {
            this.borderColor = borderColor;
            return this;
        }

        public Builder setBorderRadius(int borderRadius) {
            this.borderRadius = borderRadius;
            return this;
        }

        public Builder setBorderWidth(int borderWidth) {
            this.borderWidth = borderWidth;
            return this;
        }

        public Box build() {
            return new Box(backgroundColor, margin, width, height, horizontalPosition, verticalPosition, borderColor, borderRadius,
                    borderWidth);
        }
    }
}
